/**
 * $Id: FixtureCore.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2003 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your option) any
 * later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL (GNU Lesser General Public License) for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                           EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx;

/**
 * Marker interface for a class that is an integral feature of an iteration's fixture.
 * <p/>
 * Unlike generic {@linkplain FixtureComponent fixture components}, core fixture
 * elements are inseparable from the notion of an iteration so they are not created
 * in response to an application-supplied instruction. However, it is possible for the
 * application to configure one or more aspects of a core element for the iteration's
 * duration.
 *
 * @since    JWare/AntX 0.3
 * @author   ssmc, &copy;2003 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5
 * @.safety  n/a
 * @.group   api,infra
 * @see      FixtureAdministrator
 * @see      FixtureComponent
 **/

public interface FixtureCore
{
}

/* end-of-FixtureCore.java */
