/**
 * $Id: FixtureComponent.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2003 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your option) any
 * later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL (GNU Lesser General Public License) for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                           EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx;

/**
 * Marker interface for a data element that can be included in an iteration's
 * fixture definition through application-supplied instructions like a build or 
 * test script.
 * <p/>
 * Fixture components are fundamentally different from {@linkplain FixtureCore} elements
 * because they are created in response to an application request only; if the application
 * doesn't want them, they are not included in the iteration's fixture. FixtureCore items
 * are not data elements usually and exist as long as the iteration lives.
 * <p/>
 * The term fixture component can include anything from data objects to task instances 
 * to fixture administrators. When included, fixture components and their particular 
 * states help make one particular iteration unique from another.
 *
 * @since    JWare/AntX 0.3
 * @author   ssmc, &copy;2003 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5
 * @.safety  n/a
 * @.group   api,infra
 * @see      FixtureAdministrator
 * @see      FixtureCore
 **/

public interface FixtureComponent
{
}

/* end-of-FixtureComponent.java */
