/**
 * $Id: AntX.java 187 2007-03-25 17:59:16Z ssmc $
 * Copyright 2002-2004,2007 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your option) any
 * later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL (GNU Lesser General Public License) for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://antxtras.sf.net/          EMAIL- jware[at]users[dot]sourceforge[dot]net
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx;

import  org.apache.tools.ant.Main;

import  com.idaremedia.apis.BundleStringManager;
import  com.idaremedia.apis.UIStringManager;
import  com.idaremedia.antx.helpers.Strings;
import  com.idaremedia.antx.helpers.Tk;

/**
 * Collection of common AntX properties and constants.
 *
 * @since    JWare/AntX 0.1
 * @author   ssmc, &copy;2002-2004,2007 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5.1
 * @.safety  multiple
 * @.group   impl,helper
 **/

public final class AntX
{
//----------------------------------------------------------------------------------------
// Package and configuration identifiers
//----------------------------------------------------------------------------------------
    /**
     * A fallback name of <i>AntX</i> package(s) when buildstrs and other localized
     * resource information is unavailable. Useful for diagnostics.
     **/
    public static final String ANTX_FALLBACK_NAME =
        "JWare.AntX";


    /**
     * The standard package prefix for this <i>AntX</i> implementation.
     * Defined as "<i>com.idaremedia.antx</i>".
     **/
    public static final String ANTX_PACKAGE_PREFIX=
        "com.idaremedia.antx";


    /**
     * The default prefix for <i>AntX</i> configuration properties; usually
     * "<i>jware.antx</i>".  Properties within class-specific files are not
     * required to have this prefix. However, if the property can be specified
     * on the command-line it must have this identifying prefix.
     **/
    public static final String ANTX_CONFIG_ID =
        "jware.antx";


    /**
     * The default prefix for internal <i>AntX</i> configuration properties.
     * These properties are between AntX class implementations; they should
     * not be defined or modified by user scripts.
     **/
    public static final String ANTX_INTERNAL_ID =
        ANTX_CONFIG_ID+".internal_.";


//----------------------------------------------------------------------------------------
// AntX configuration properties (all fully qualified property names)
//----------------------------------------------------------------------------------------

    /** Property for default AntX noise-level. **/
    public final static String DEFAULT_NOISELEVEL_PROP =
        ANTX_CONFIG_ID+".noiselevel";


    /** Property for default AntX logging category id. **/
    public final static String DEFAULT_ROOT_CATEGORY_PROP =
        ANTX_CONFIG_ID+".root.category";


    /** Property for a default root UIStringManager's bundle. **/
    public final static String DEFAULT_UISTRS_BUNDLE_PROP =
        ANTX_CONFIG_ID+".default.messages.bundle";


    /** Property for whether properties checked for msgids. **/
    public final static String PROPERTY_MSGIDS_PROP =
        ANTX_CONFIG_ID+".allow.property.msgids";


    /** Property for default AntX temporary file-system object prefix. **/
    public final static String DEFAULT_TEMPOBJECT_PREFIX_PROP =
        ANTX_CONFIG_ID+".tempobject.prefix";


    /** Property for default false &lt;prefer&gt; warnings. **/
    public final static String PROPERTY_FALSE_PREFER_NOISELEVEL_PROP =
        ANTX_CONFIG_ID+".noiselevel.false.prefers";


    /** Property to control whether AntX tasks verify content on load. **/
    public final static String STRICT_SCRIPTCHECK_PROP=
        ANTX_CONFIG_ID+".strict.scriptcheck.enabled";


//----------------------------------------------------------------------------------------
// AntX defaults for required configuration properties (source shouldn't use other)
//----------------------------------------------------------------------------------------

    /** The default diagnostics and other message noise level (<i>info</i>). **/
    public final static String DEFAULT_NOISELEVEL = "info";

    /** The default <em>client</em> UIStrings resource bundle name. **/
    public final static String DEFAULT_UISTRS_RESOURCEBUNDLE =
        ANTX_CONFIG_ID+".UIStrings";

    /** The default delimiter used in delimited string lists. **/
    public final static String DEFAULT_DELIMITER= ",";


//----------------------------------------------------------------------------------------
// AntX Tracing/Assertion categories
//----------------------------------------------------------------------------------------

    /** Top of JWare's AntX namespace for error messages and assertions. **/
    public final static String AntX= ANTX_FALLBACK_NAME+".";

    /** AntX's "no-package" module identifier. **/
    public final static String nopackage= AntX+"core";

    /** AntX's UISM sub-module identifier. **/
    public final static String uism= AntX+"uism.";

    /** AntX's rules sub-module identifier. **/
    public final static String rules= AntX+"rules.";

    /** AntX's rules conditions sub-module identifier. **/
    public final static String conditions= rules+"conditions.";
    
    /** AntX's rules capture module identifier. 
     * @since JWare/AntX 0.5
     **/
    public final static String capture= rules+"capture.";

    /** AntX's flow-control module identifier. **/
    public final static String flow= AntX+"flowcontrol.";

    /** AntX's print sub-module identifier. **/
    public final static String print= AntX+"print.";

    /** AntX's mktemp helpers sub-module identifier. **/
    public final static String mktemp= AntX+"mktemp.";

    /** AntX's starters sub-module identifier. **/
    public final static String starters= AntX+"starters.";

    /** AntX's feedback (emit) module identifier. **/
    public final static String feedback= AntX+"feedback.";

    /** AntX's general utilities group identifier.
     *  @since JWare/AntX 0.4
     **/
    public final static String utilities= AntX+"helpers.";

    /** AntX's general fixture element group identifier.
     *  @since JWare/AntX 0.5
     **/
    public final static String fixture= AntX+"fixture.";

    /** AntX's artifacts module identifier.
     *  @since JWare/AntX 0.4
     **/
    public final static String artifacts= AntX+"artifacts.";


//----------------------------------------------------------------------------------------
// AntX (project) fixed UI-Strings
//----------------------------------------------------------------------------------------

    private static UIStringManager sm_UISM=
        new BundleStringManager(ANTX_PACKAGE_PREFIX+".uistrs.UIStrings");


    /**
     * Returns instance of the <em>internal JWare/AntX</em> UIStringManager.
     * This manager is <em>not</em> controlled by any task's 'msgid' attribute
     * or otherwise. The underlying bundle is part of the AntX class package.
     **/
    public static final UIStringManager uistrs()
    {
        return sm_UISM;
    }



    /**
     * Msgid of common "clone is really broken" associated with Cloneables
     * capturing a CloneNotSupportedException. Should never happen, but&#46;&#46;&#46;
     **/
    public static final String CLONE_BROKEN_MSGID= "cv.clone.broken";



    /**
     * True if AntX tasks should verify themselves (or their contents)
     * as they're being created instead of just before they're executed.
     * Defaults <i>false</i>. This property is to counteract Ant 1.6+
     * mapping of <em>all</em> script elements to UnknownElement
     * placeholders until just before execution or referenced.
     * @since JWare/AntX 0.4
     * @see #STRICT_SCRIPTCHECK_PROP
     **/
    public static final boolean STRICT_SCRIPTS;
    
    /**
     * True if the current Ant runtime is pre-1&#46;7 (a 1&#46;6 variant).
     * @since JWare/AntXtras 0.5.1
     */
    public static final boolean ANT_PRE17;
    
    /**
     * Contains the current Ant runtime's version string as best we can 
     * determine with explicitly reading the version information ourselves.
     * @since JWare/AntXtras 0.5.1
     */
    public static final String ANT_VERSIONSTRING;

    static {
        //NB:This is fracking hack to deal with Ant's inability to make up its
        //   mind regarding build file parsing and component initialization!
        boolean pre17=false;
        String versionstring= Strings.UNDEFINED;
        String av = Main.getAntVersion();
        if (av.indexOf("version 1.6")>0) {
            pre17 = true;
        }
        final int _0 = av.indexOf("Ant version ");
        final int _n = av.indexOf(" compiled");
        if (_0>=0 && _n>0) {
            versionstring = av.substring(_0+"Ant version ".length(),_n);
        }
        String s = System.getProperty(STRICT_SCRIPTCHECK_PROP);
        if (s!=null) {
            STRICT_SCRIPTS = Tk.booleanFrom(s);
        } else {
            STRICT_SCRIPTS = true; //Ant 1.6,1.7
        }
        ANT_PRE17 = pre17;
        ANT_VERSIONSTRING = versionstring;
    }



    /**
     * Throws an illegal argument exception if a pre-condition
     * is not met.
     * @param c the pre-condition
     * @param msg [optional] failure message (if not met)
     * @throws IllegalArgumentException if condition not met
     * @since JWare/AntX 0.4
     **/
    public static final void require_(boolean c, String iam, String msg)
    {
        if (!c) {
            String ermsg = uistrs().get("cv.require",iam,msg);
            throw new IllegalArgumentException(ermsg);
        }
    }




    /**
     * Throws an illegal state exception if condition is not met.
     * Used for block and invariant verification.
     * @param c condition
     * @param msg [optional] failure message (if not met)
     * @throws IllegalStateException if condition not met
     * @since JWare/AntX 0.4
     **/
    public static final void verify_(boolean c, String iam, String msg)
    {
        if (!c) {
            String ermsg = uistrs().get("cv.verify",iam,msg);
            throw new IllegalStateException(ermsg);
        }
    }



    /** -- nope nope -- prevent construction of any instances -- **/
    private AntX() { }
}

/* end-of-AntX.java */
