<!--
  This pattern expects straight quotation marks to be used in code fragments only.
-->
<sch:pattern id="code_quotes_straight" xmlns:sch="http://purl.oclc.org/dsdl/schematron">

  <sch:rule context="fragment//monospace[contains(text(), '&quot;')]">

    <sch:assert test="not(matches(self::monospace, '^&quot;[a-zA-Z0-9-]+&quot;$'))"
                id="straight_quotes_code_wrap"
                properties="fragment" flag="tip"
    >Found suspicious code value <sch:value-of select="text()"/> surrounded by quotation marks ("). Remove the quotes.</sch:assert>

  </sch:rule>

  <sch:rule context="fragment//*[contains(text(), '&quot;')]">

    <sch:assert test="self::monospace|ancestor::monospace
                     |self::preformat|ancestor::preformat"
                id="straight_quotes_in_text"
                properties="fragment" flag="tip"
    >Found straight quotation mark (") in text. Use typographical quotation marks instead.</sch:assert>

  </sch:rule>

</sch:pattern>
