<?xml version="1.0"?>
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:b="http://schemas.openxmlformats.org/officeDocument/2006/bibliography"
                exclude-result-prefixes="#all">
  
  <xsl:template match="/b:Sources">
    <xsl:copy>
      <xsl:copy-of select="@*" />
      <xsl:apply-templates />
    </xsl:copy>
  </xsl:template>

  <!-- incomplete citation -->
  <xsl:template match="properties-fragment[@type='citation' and not(.//xref)]">
    <b:Source>
      <b:Tag><xsl:value-of select="@id" /></b:Tag>
      <b:SourceType>Misc</b:SourceType>
      <b:Author>
        <b:Author>
          <b:NameList>
            <b:Person>
              <b:Last><xsl:value-of select="property[@name='link-text']/@value" /></b:Last>
            </b:Person>
          </b:NameList>
        </b:Author>
      </b:Author>
      <b:Title><xsl:value-of select="string-join(property[@name='description']/*,' ')" /></b:Title>
    </b:Source>
  </xsl:template>
  
  <!-- complete citation -->
  <xsl:template match="properties-fragment[@type='citation' and .//xref]">
    <b:Source>
      <b:Tag><xsl:value-of select="@id" /></b:Tag>
      <b:SourceType>
        <xsl:choose>
          <xsl:when test=".//properties-fragment[@type='book']">Book</xsl:when>
          <xsl:when test=".//properties-fragment[@type='website']">InternetSite</xsl:when>
          <xsl:when test=".//properties-fragment[@type='electronic-source']">ElectronicSource</xsl:when>
          <xsl:when test=".//properties-fragment[@type='periodical-article']">ArticleInAPeriodical</xsl:when>
          <xsl:otherwise>Misc</xsl:otherwise>
        </xsl:choose>
      </b:SourceType>
      <b:Author>
        <xsl:if test=".//properties-fragment[@type='author']">
          <b:Author>
            <b:NameList>
              <xsl:apply-templates select=".//properties-fragment[@type='author']" />
            </b:NameList>
          </b:Author>
        </xsl:if>
        <xsl:apply-templates select=".//properties-fragment[@type='corporate-author']" />
      </b:Author>
      <xsl:apply-templates select=".//properties-fragment[@type='book' or @type='electronic-source'
           or @type='website' or @type='periodical-article' or @type='misc']/property" />
    </b:Source>
  </xsl:template>

  <xsl:template match="properties-fragment[@type='corporate-author']">
    <b:Author>
      <b:Corporate><xsl:value-of select="property[@name='corporate-name']/@value" /></b:Corporate>
    </b:Author>
  </xsl:template>

  <xsl:template match="properties-fragment[@type='author']">
    <b:Person>
      <xsl:apply-templates mode="author" />
    </b:Person>
  </xsl:template>

  <xsl:template match="property[@name='first-name']" mode="author">
    <b:First><xsl:value-of select="@value" /></b:First>
  </xsl:template>

  <xsl:template match="property[@name='middle-name']" mode="author">
    <b:Middle><xsl:value-of select="@value" /></b:Middle>
  </xsl:template>

  <xsl:template match="property[@name='last-name']" mode="author">
    <b:Last><xsl:value-of select="@value" /></b:Last>
  </xsl:template>

  <xsl:template match="property[@name='title']">
    <b:Title><xsl:value-of select="@value" /></b:Title>
  </xsl:template>

  <xsl:template match="property[@name='city']">
    <b:City><xsl:value-of select="@value" /></b:City>
  </xsl:template>

  <xsl:template match="property[@name='state-province']">
    <b:StateProvince><xsl:value-of select="@value" /></b:StateProvince>
  </xsl:template>

  <xsl:template match="property[@name='country-region']">
    <b:CountryRegion><xsl:value-of select="@value" /></b:CountryRegion>
  </xsl:template>

  <xsl:template match="property[@name='publisher']">
    <b:Publisher><xsl:value-of select="@value" /></b:Publisher>
  </xsl:template>

  <xsl:template match="property[@name='site-name']">
    <b:InternetSiteTitle><xsl:value-of select="@value" /></b:InternetSiteTitle>
  </xsl:template>

  <xsl:template match="property[@name='production-company']">
    <b:ProductionCompany><xsl:value-of select="@value" /></b:ProductionCompany>
  </xsl:template>

  <xsl:template match="property[@name='year']">
    <b:Year><xsl:value-of select="@value" /></b:Year>
  </xsl:template>

  <xsl:template match="property[@name='month']">
    <b:Month><xsl:value-of select="@value" /></b:Month>
  </xsl:template>

  <xsl:template match="property[@name='day']">
    <b:Day><xsl:value-of select="@value" /></b:Day>
  </xsl:template>

  <xsl:template match="property[@name='year-accessed']">
    <b:YearAccessed><xsl:value-of select="@value" /></b:YearAccessed>
  </xsl:template>

  <xsl:template match="property[@name='month-accessed']">
    <b:MonthAccessed><xsl:value-of select="@value" /></b:MonthAccessed>
  </xsl:template>

  <xsl:template match="property[@name='day-accessed']">
    <b:DayAccessed><xsl:value-of select="@value" /></b:DayAccessed>
  </xsl:template>

  <xsl:template match="property[@name='url']">
    <b:URL><xsl:value-of select="@value" /></b:URL>
  </xsl:template>

  <xsl:template match="property[@name='periodical-title']">
    <b:PeriodicalTitle><xsl:value-of select="@value" /></b:PeriodicalTitle>
  </xsl:template>

  <xsl:template match="property[@name='edition']">
    <b:Edition><xsl:value-of select="@value" /></b:Edition>
  </xsl:template>

  <xsl:template match="property[@name='publication-title']">
    <b:PublicationTitle><xsl:value-of select="@value" /></b:PublicationTitle>
  </xsl:template>

  <xsl:template match="property[@name='volume']">
    <b:Volume><xsl:value-of select="@value" /></b:Volume>
  </xsl:template>

  <xsl:template match="property[@name='issue']">
    <b:Issue><xsl:value-of select="@value" /></b:Issue>
  </xsl:template>

  <xsl:template match="property[@name='standard-number']">
    <b:StandardNumber><xsl:value-of select="@value" /></b:StandardNumber>
  </xsl:template>

</xsl:stylesheet>

