<!-- Checks that a defintion document exists for trems with definition inline label -->
<sch:pattern id="definition_check" xmlns:sch="http://purl.oclc.org/dsdl/schematron">

  <sch:let name="definitions" value="document('ps:search?filters=psdocumenttype:definition&amp;pagesize=2000')" />

  <sch:rule context="inline[@label='definition']">

    <sch:let name="lc"
             value="lower-case(.)" />

    <sch:let name="lc-singular"
             value="if (ends-with(.,'s'))
                    then lower-case(substring(., 1, string-length(.)-1))
                    else lower-case(.)" />

    <sch:let name="matches"
             value="count($definitions//field[
                      (@name='pstitle' and (lower-case(.)=$lc or lower-case(.)=$lc-singular)) or
                      (@name='psproperty-synonym' and (lower-case(.)=$lc or lower-case(.)=$lc-singular))])" />

    <!-- Definitions must exist -->
    <sch:assert id="definition_missing" test="$matches gt 0"
                properties="fragment">
      The definition for "<sch:value-of select="."/>" does not exist.
    </sch:assert>

    <!-- Terms must only match one definition -->
    <sch:assert id="multiple_definition" test="$matches lt 2"
                properties="fragment">
      There are multiple definitions for "<sch:value-of select="."/>".
    </sch:assert>

  </sch:rule>

</sch:pattern>