<!--
  ~ Copyright (c) 1999-2019 Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="3.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:json="http://www.w3.org/2005/xpath-functions"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='api-loadingzone-inspect']" mode="json">
  <json:map>
    <json:array key="fields">
      <xsl:for-each select="//file/field">
        <json:map>
          <json:string key="name"><xsl:value-of select="@name" /></json:string>
          <json:string key="value"><xsl:value-of select="@value" /></json:string>
        </json:map>
      </xsl:for-each>
    </json:array>
    <json:array key="metadata">
      <xsl:for-each select="//file/metadata/property">
        <json:map>
          <json:string key="name"><xsl:value-of select="@name" /></json:string>
          <json:string key="title"><xsl:value-of select="@title" /></json:string>
          <json:array key="values">
            <xsl:for-each select="(@value | value)[. != '']">
              <json:string><xsl:value-of select="." /></json:string>
            </xsl:for-each>
          </json:array>
        </json:map>
      </xsl:for-each>
    </json:array>
  </json:map>
</xsl:template>

</xsl:stylesheet>
