<!--
  ~ Copyright (c) 1999-2019 Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="3.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:json="http://www.w3.org/2005/xpath-functions"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='api-group-admin-bundles']" mode="json">
  <json:array>
    <xsl:for-each select="content/bundles">
      <xsl:apply-templates select="bundle" mode="json"/>
    </xsl:for-each>
  </json:array>
</xsl:template>

<xsl:template match="bundle" mode="json">
  <json:map>
    <json:string key="name"><xsl:value-of select="@name"/></json:string>
    <json:string key="type"><xsl:value-of select="@type"/></json:string>
    <json:array key="files">
      <xsl:for-each select="file">
        <json:map>
          <xsl:for-each select="@name|@path|@type|@mediatype|@modified|@role|@definedby|@status">
            <json:string key="{name()}"><xsl:value-of select="."/></json:string>
          </xsl:for-each>
          <xsl:for-each select="@text|@editable">
            <json:boolean key="{name()}"><xsl:value-of select=". = 'true'"/></json:boolean>
          </xsl:for-each>
          <xsl:if test="@length and @length castable as xs:double">
            <json:number key="length"><xsl:value-of select="@length"/></json:number>
          </xsl:if>
        </json:map>
      </xsl:for-each>
    </json:array>
  </json:map>
</xsl:template>

</xsl:stylesheet>
