<!--
  ~ Copyright (c) 1999-2018 Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="3.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:json="http://www.w3.org/2005/xpath-functions"
                xmlns:f="http://www.pageseeder.com/function"
                exclude-result-prefixes="#all">

<!-- Access logs -->
<xsl:template match="root[@service='api-admin-organization']" mode="json">
  <json:map>

    <xsl:variable name="ui" select="//ui" />
    <xsl:if test="$ui">
      <json:map key="ui">
        <xsl:if test="$ui/style/@theme">
          <json:string key="theme"><xsl:value-of select="$ui/style/@theme" /></json:string>
        </xsl:if>
        <xsl:if test="$ui/images[@logo-filename or @icon-filename]">
          <json:map key="images">
            <xsl:if test="$ui/images/@logo-filename"><json:string key="logo"><xsl:value-of select="$ui/images/@logo-filename" /></json:string></xsl:if>
            <xsl:if test="$ui/images/@icon-filename"><json:string key="icon"><xsl:value-of select="$ui/images/@icon-filename" /></json:string></xsl:if>
          </json:map>
        </xsl:if>
        <xsl:if test="$ui/legal/document">
          <json:array key="legal">
            <xsl:for-each select="$ui/legal/document">
              <json:map>
                <xsl:if test="@name"><json:string key="name"><xsl:value-of select="@name" /></json:string></xsl:if>
                <xsl:if test="@title"><json:string key="title"><xsl:value-of select="@title" /></json:string></xsl:if>
                <xsl:if test="@agree-on"><json:string key="agreeOn"><xsl:value-of select="@agree-on" /></json:string></xsl:if>
              </json:map>
            </xsl:for-each>
          </json:array>
        </xsl:if>
        <xsl:if test="$ui/account-home">
          <json:map key="accountHome">
            <json:array key="links">
              <xsl:for-each select="$ui/account-home/link">
                <json:map>
                  <xsl:if test="@href"><json:string key="href"><xsl:value-of select="@href" /></json:string></xsl:if>
                  <xsl:if test="@title"><json:string key="title"><xsl:value-of select="@title" /></json:string></xsl:if>
                </json:map>
              </xsl:for-each>
            </json:array>
            <json:array key="widgets">
              <xsl:for-each select="$ui/account-home/widget">
                <json:map>
                  <json:string key="name"><xsl:value-of select="@name" /></json:string>
                  <xsl:if test="@size"><json:string key="size"><xsl:value-of select="@size" /></json:string></xsl:if>
                  <xsl:if test="@rowspan"><json:string key="rowspan"><xsl:value-of select="@rowspan" /></json:string></xsl:if>
                  <json:array key="parameters">
                    <xsl:for-each select="parameters/@*">
                      <json:map>
                        <json:string key="name"><xsl:value-of select="name()" /></json:string>
                        <json:string key="value"><xsl:value-of select="." /></json:string>
                      </json:map>
                    </xsl:for-each>
                  </json:array>
                </json:map>
              </xsl:for-each>
            </json:array>
          </json:map>
        </xsl:if>
      </json:map>
    </xsl:if>

    <xsl:variable name="security" select="//security" />
    <xsl:if test="$security">
      <json:map key="security">
        <xsl:if test="string($security/login/@groups) != ''">
          <json:array key="loginGroups">
            <xsl:for-each select="tokenize($security/login/@groups, ',')">
              <json:string><xsl:value-of select="."/></json:string>
            </xsl:for-each>
          </json:array>
        </xsl:if>
        <xsl:if test="string($security/login/@projects) != ''">
          <json:array key="loginProjects">
            <xsl:for-each select="tokenize($security/login/@projects, ',')">
              <json:string><xsl:value-of select="."/></json:string>
            </xsl:for-each>
          </json:array>
        </xsl:if>
        <xsl:if test="$security/members/email">
          <json:array key="memberEmailDomains">
            <xsl:for-each select="$security/members/email">
              <json:string><xsl:value-of select="@domain"/></json:string>
            </xsl:for-each>
          </json:array>
        </xsl:if>
        <xsl:if test="$security/token">
          <json:array key="tokens">
            <xsl:for-each select="$security/token">
              <json:map>
                <json:string key="type"><xsl:value-of select="@type"/></json:string>
                <json:string key="expiration"><xsl:value-of select="@expiration"/></json:string>
              </json:map>
            </xsl:for-each>
          </json:array>
        </xsl:if>
      </json:map>
    </xsl:if>

  </json:map>
</xsl:template>

</xsl:stylesheet>
