<?xml version="1.0" encoding="UTF-8"?>
<!--
  ~ Copyright (c) 1999-2019 Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:v-bind="https://vuejs.org"
                xmlns:f="http://www.pageseeder.com/function"
                xmlns:json="http://www.w3.org/2005/xpath-functions"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='getstarted']" mode="html-title" as="xs:string*">
  <xsl:sequence select="('Get started')"/>
</xsl:template>

<xsl:template match="root[@service='getstarted']" mode="main-content">
<div class="main-content">
  <main-panel>
    <centered-box>
      <xsl:choose>
        <xsl:when test="$session/member">
          <callout-box type="warning">
            <p>You're already logged in as '<xsl:value-of select="if ($session/member/@username) then $session/member/@username else $session/member/@username"/>'.</p>
          </callout-box>
          <p>Please sign out first to activate your account.</p>
          <p><a href="{$site-prefix}/ui/signout.html" class="button">sign out</a></p>
        </xsl:when>
        <xsl:otherwise>
          <xsl:variable name="member" select="//content/member"/>
          <xsl:variable name="token" select="//parameter[@name='token']"/>
          <xsl:variable name="legal-documents">
            <json:array>
              <xsl:for-each select="//ui/legal/document[@agree-on = 'signup' or @agree-on = 'all']">
                <json:map>
                  <json:string key="name"><xsl:value-of select="@name"/></json:string>
                  <json:string key="title"><xsl:value-of select="@title"/></json:string>
                </json:map>
              </xsl:for-each>
            </json:array>
          </xsl:variable>
          <getstarted-form v-bind:member="{if ($member) then f:to-json($member) else 'null'}"
                           v-bind:legal="{f:xml-to-json($legal-documents)}"
                           token="{$token}"/>
        </xsl:otherwise>
      </xsl:choose>
    </centered-box>
  </main-panel>
</div>
</xsl:template>

</xsl:stylesheet>
