<?xml version="1.0" encoding="UTF-8"?>
<!--
  ~ Copyright (c) 1999-2019 Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:f="http://www.pageseeder.com/function"
                xmlns:v-bind="https://vuejs.org"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='project-members']" mode="html-title" as="xs:string*">
  <xsl:sequence select="('Members')"/>
</xsl:template>

<xsl:template match="root[@service='project-members']" mode="main-content">
<div class="main-content">
  <main-panel>
    <div class="container">
      <xsl:variable name="project" select="$context/project"/>

      <xsl:if test="$session/permissions[@admin-system='true' or @edit-group='true']">
        <a href="{$site-prefix}/ui/p/{$project/@name}/admin/members.html" class="button alert float-right"><svg-icon name="wrench"/> Manage members</a>
      </xsl:if>

      <h1 class="page-title"><svg-icon name="member-groups"/> Members of <em><xsl:value-of select="if ($project/@title) then $project/@title else $project/@name"/></em></h1>

      <group-members v-bind:group="{f:to-json($project)}"/>

    </div>
  </main-panel>
  <side-panel side="right"/>
</div>
</xsl:template>

</xsl:stylesheet>
