<?xml version="1.0" encoding="UTF-8"?>
<!--
  ~ Copyright (c) 1999-2019 Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:f="http://www.pageseeder.com/function"
                xmlns:v-bind="https://vuejs.org"
                xmlns:json="http://www.w3.org/2005/xpath-functions"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='project-labels']" mode="html-title" as="xs:string*">
  <xsl:sequence select="('Labels')"/>
</xsl:template>

<xsl:template match="root[@service='project-labels']" mode="main-content">
<div class="main-content">
  <main-panel>
    <div class="container">

      <xsl:if test="$session/permissions[@admin-system='true' or @config-project='true']">
        <a href="{$site-prefix}/ui/p/{$current-project}/admin/labels.html" class="button alert float-right"><svg-icon name="wrench"/> Manage labels</a>
      </xsl:if>

      <h1 class="page-title"><svg-icon name="label"/> Project labels</h1>

      <project-labels project="{$current-project}" member="{$session/member/@id}"
                      v-bind:initial-labels="{f:to-json-all-labels(content/label-config, content/document-types, content//xref-configs)}">
        <xsl:if test="$session/member/@admin = 'true'"><xsl:attribute name="admin" /></xsl:if>
      </project-labels>
    </div>
  </main-panel>
  <side-panel side="right"/>
</div>
</xsl:template>

</xsl:stylesheet>
