<?xml version="1.0" encoding="UTF-8"?>
<!--
  ~ Copyright (c) 1999-2019 Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:f="http://www.pageseeder.com/function"
                xmlns:v-bind="https://vuejs.org"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='group-members']" mode="html-title" as="xs:string*">
  <xsl:sequence select="('Members')"/>
</xsl:template>

<xsl:template match="root[@service='group-members']" mode="main-content">
<div class="main-content">
  <main-panel>
    <div class="container">
      <xsl:variable name="group" select="//context/group"/>

      <!-- Managers and system administrators can manage members -->
      <xsl:if test="$session/permissions[@admin-system='true' or @edit-group='true']">
        <form-button href="{$site-prefix}/ui/g/{$group/@name}/admin/members.html" alert="" class="float-right"><svg-icon name="wrench"/> Manage members</form-button>
      </xsl:if>

      <h1 class="page-title"><svg-icon name="member-groups"/> Members of <em><xsl:value-of select="if ($group/@title) then $group/@title else $group/@name"/></em></h1>

      <group-members v-bind:group="{f:to-json($group)}"/>

    </div>
  </main-panel>
  <side-panel side="right"/>
</div>
</xsl:template>

</xsl:stylesheet>
