<?xml version="1.0" encoding="UTF-8"?>
<!--
  ~ Copyright (c) 1999-2019 Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:f="http://www.pageseeder.com/function"
                xmlns:json="http://www.w3.org/2005/xpath-functions"
                xmlns:v-bind="https://vuejs.org"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='group-home']" mode="html-title" as="xs:string*">
  <xsl:sequence select="('Home')"/>
</xsl:template>

<xsl:template match="root[@service='group-home']" mode="main-content">
  <xsl:variable name="opentask-count" select="//facet[@name='psstatus']/term[@text='Open']/@cardinality"/>
  <xsl:variable name="comment-count" select="//facet[@name='pstype']/term[@text='comment']/@cardinality"/>
  <xsl:variable name="document-count" select="//facet[@name='pstype']/term[@text='document']/@cardinality"/>
  <xsl:variable name="publish-actions"><json:array>
    <xsl:apply-templates select="content/publish-config/publishing/action/target" mode="json" />
  </json:array></xsl:variable>

  <group-banner v-bind:tasks="{if ($opentask-count) then $opentask-count else 0}"
                v-bind:comments="{if ($comment-count) then $comment-count else 0}"
                v-bind:documents="{if ($document-count) then $document-count else 0}">
  </group-banner>

  <group-home-bar v-bind:publish-actions="{f:xml-to-json($publish-actions)}" />

  <div class="main-content">
    <main-panel full-width="">
      <group-home-main />
    </main-panel>
    <side-panel side="right"/>
  </div>
</xsl:template>

</xsl:stylesheet>
