<?xml version="1.0" encoding="UTF-8"?>
<!--
  ~ Copyright (c) 1999-2019 Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:f="http://www.pageseeder.com/function"
                xmlns:v-bind="https://vuejs.org"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='group-discussions']" mode="html-title" as="xs:string*">
  <xsl:sequence select="('Discussions')"/>
</xsl:template>

<xsl:template match="root[@service='group-discussions']" mode="main-content">
  <group-discussion-bar />

  <div class="main-content">
    <side-panel side="left" v-bind:width="400"/>
    <main-panel>
      <div class="container">
        <xsl:variable name="comment-id" select="number(//parameter[@name='discussion'])"/>
        <group-discussion-viewer v-bind:comment-id="{if ($comment-id) then $comment-id else '0'}"/>
      </div>
    </main-panel>
    <side-panel side="right"/>
  </div>
</xsl:template>

</xsl:stylesheet>
