<?xml version="1.0" encoding="UTF-8"?>
<!--
  ~ Copyright (c) 1999-2020 Allette Systems Pty Ltd
-->
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:f="http://www.pageseeder.com/function"
                xmlns:v-bind="https://vuejs.org"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='group-admin-config']" mode="html-title" as="xs:string*">
  <xsl:sequence select="('Group configuration')"/>
</xsl:template>

<xsl:template match="root[@service='group-admin-config']" mode="main-content">
<xsl:variable name="moderator" select="(content//membership[@role='moderator' or @role='moderator-and-approver']/member)[1]" />
<xsl:variable name="emaildomain" select="if (//constants/@email-domain = 'pshosts') then content/context/defaulthost else //constants/@email-domain"/>
<div class="main-content">
  <main-panel>
    <h1 class="page-title"><svg-icon name="cog"/> Group configuration</h1>
    <group-configuration email-domain="{$emaildomain}"
                         v-bind:group="{f:to-json(content/group[1])}"
                         v-bind:moderator="{f:to-json($moderator)}"
                         v-bind:properties="{f:to-json-group-properties(content/properties)}" />
  </main-panel>
  <side-panel side="right"/>
</div>
</xsl:template>

</xsl:stylesheet>
