<?xml version="1.0" encoding="UTF-8"?>
<!--
  ~ Copyright (c) 1999-2020 Allette Systems Pty Ltd
-->
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:f="http://www.pageseeder.com/function"
                xmlns:v-bind="https://vuejs.org"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='admin-projects-create']" mode="html-title" as="xs:string*">
  <xsl:sequence select="('Create project')"/>
</xsl:template>

<xsl:template match="root[@service='admin-projects-create']" mode="main-content">
<xsl:variable name="website-address" select="//constants/@website-address"/>
<xsl:variable name="emaildomain" select="if (//constants/@email-domain = 'pshosts') then content/context/defaulthost else //constants/@email-domain"/>
<div class="main-content">
  <main-panel>
    <h1 class="page-title"><svg-icon name="group"/> Create a new <xsl:if test="//context/project">sub</xsl:if>project</h1>
    <project-creation default-host="{$website-address}"
                      default-owner="{//context/project/@owner}"
                      email-domain="{$emaildomain}"
                      parent-project="{//context/project/@name}"
                      v-bind:available-hosts="{f:to-json-array(//hosts/host/@name)}"
                      v-bind:properties="{f:to-json-group-properties(content/properties)}" />
  </main-panel>
  <side-panel side="right"/>
</div>
</xsl:template>

</xsl:stylesheet>
