<?xml version="1.0" encoding="UTF-8"?>
<!--
  ~ Copyright (c) 1999-2018 Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:f="http://www.pageseeder.com/function"
                xmlns:v-bind="https://vuejs.org"
                xmlns:v-slot="https://vuejs.org"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='admin-project-scripts']" mode="html-title" as="xs:string*">
  <xsl:sequence select="('Publish scripts')"/>
</xsl:template>

<xsl:template match="root[@service='admin-project-scripts']" mode="main-content">
<div class="main-content">
  <xsl:variable name="project-files" select="content[@name = 'project-files']" />
  <main-panel>
    <h1 class="page-title"><svg-icon name="file-template"/> Publish scripts</h1>

    <xsl:variable name="project-template" select="content/context/project/@template" />
    <xsl:choose>
      <xsl:when test="contains($current-project, '-') and $current-project != $project-template">
        <p>
          This subproject uses the <a
            href="{$site-prefix}/ui/admin/p/{$project-template}/scripts.html"><xsl:value-of select="$project-template" />
        </a> template publish scripts. <br />
          To make different customizations for this subproject change the template under <a
              href="{$site-prefix}/ui/p/{$current-project}/admin/config.html">project configuration</a>.</p>
      </xsl:when>
      <xsl:otherwise>
        <div class="intro">
          <p>This project defines <b><xsl:value-of select="count(.//publishing[@project = $current-project]/action/target)"/></b> publishing actions.</p>
          <a class="button small" href="{$site-prefix}/ui/admin/p/{$current-project}/scripts/validate.html">Validate&#160;all</a>
          <callout-box type="info">
            <p>Publish scripts must be configured using the following PageSeeder links before they can be created/edited here:</p>
            <ul>
              <li>
                <file-edit-link project="{$current-project}" location="/WEB-INF/config/template/{$current-project}/publish/schedule-config.xml">
                  Configure scripts for scheduled events
                </file-edit-link>
                by creating &lt;event&gt; elements.
              </li>
              <li>
                <file-edit-link project="{$current-project}" location="/WEB-INF/config/template/{$current-project}/publish/publish-config.xml">
                  Configure scripts for group, folder, batch or document
                </file-edit-link>
                by creating &lt;action&gt; elements with a source of that type.
              </li>
              <li><a href="{$site-prefix}/ui/p/{$current-project}/admin/types.html">Configure scripts for PSML document/URL types</a> by editing the &lt;publishing&gt; element in document/URL configs.</li>
            </ul>
          </callout-box>
        </div>

        <xsl:variable name="scheduled-events" select="content/schedule/event[project = $current-project]" />
        <h2 class="section-title">Scheduled publish <a href="{header/location/@path}?reload-schedule=true" title="Reload schedule events" class="button small float-right"><svg-icon name="reload" /> refresh</a></h2>
        <table is="vue:basic-table" zebra="" show-columns="">
          <thead><tr><th>Target</th><th class="status">Status</th></tr></thead>
          <tbody>
            <xsl:apply-templates select="$scheduled-events" mode="publish-scripts" />
            <xsl:variable name="ant-script-path" select="concat('/WEB-INF/config/template/', $current-project, '/schedule/build.xml')" />
            <!-- empty? -->
            <xsl:choose>
              <xsl:when test="empty($scheduled-events) and //content//file[@path = $ant-script-path]">
                <tr>
                  <td>No scheduled publish events are defined but a script is available</td>
                  <td>
                    <dropdown-button class="small is-light">
                      <file-edit-link project="{$current-project}" location="{$ant-script-path}"><svg-icon name="pencil"/> not configured</file-edit-link>
                      <template v-slot:menu="">
                        <ul>
                          <li>
                            <a href="{$site-prefix}/ui/admin/p/{$current-project}/files.html?select={encode-for-uri($ant-script-path)}"
                            ><svg-icon name="folder"/> open folder</a>
                          </li>
                        </ul>
                      </template>
                    </dropdown-button>
                  </td>
                </tr>
              </xsl:when>
              <xsl:when test="empty($scheduled-events)">
                <tr><td colspan="2">No scheduled publish events are defined</td></tr>
              </xsl:when>
            </xsl:choose>
          </tbody>
        </table>

        <xsl:variable name="group-targets" select=".//publishing[@project = $current-project]/action[source/@type = 'group']/target" />
        <xsl:variable name="group-scripts" select="f:undefined-scripts($project-files//file, 'group', $group-targets)" />
        <h2 class="section-title">Group publish</h2>
        <table is="vue:basic-table" zebra="" show-columns="">
          <thead><tr><th class="type">Action type</th><th class="name">Target</th><th class="status">Status</th></tr></thead>
          <tbody>
            <xsl:apply-templates select="$group-targets" mode="publish-scripts" />
            <xsl:apply-templates select="$group-scripts" mode="publish-scripts" />
            <xsl:if test="empty($group-targets | $group-scripts)">
              <tr><td colspan="3">No group publish scripts are defined</td></tr>
            </xsl:if>
          </tbody>
        </table>

        <xsl:variable name="folder-targets" select=".//publishing[@project = $current-project]/action[source/@type = 'folder']/target" />
        <xsl:variable name="folder-scripts" select="f:undefined-scripts($project-files//file, 'folder', $folder-targets)" />
          <h2 class="section-title">Folder publish</h2>
          <table is="vue:basic-table" zebra="" show-columns="">
          <thead><tr><th class="type">Action type</th><th class="name">Target</th><th class="status">Status</th></tr></thead>
          <tbody>
            <xsl:apply-templates select="$folder-targets" mode="publish-scripts" />
            <xsl:apply-templates select="$folder-scripts" mode="publish-scripts" />
            <xsl:if test="empty($folder-targets | $folder-scripts)">
              <tr><td colspan="3">No folder publish scripts are defined</td></tr>
            </xsl:if>
          </tbody>
        </table>

        <xsl:variable name="batch-targets" select=".//publishing[@project = $current-project]/action[source/@type = 'batch']/target" />
        <xsl:variable name="batch-scripts" select="f:undefined-scripts($project-files//file, 'batch', $batch-targets)" />
        <h2 class="section-title">Batch publish</h2>
        <table is="vue:basic-table" zebra="" show-columns="">
          <thead><tr><th class="type">Action type</th><th class="name">Target</th><th class="status">Status</th></tr></thead>
          <tbody>
            <xsl:apply-templates select="$batch-targets" mode="publish-scripts" />
            <xsl:apply-templates select="$batch-scripts" mode="publish-scripts" />
            <xsl:if test="empty($batch-targets | $batch-scripts)">
              <tr><td colspan="3">No batch publish scripts are defined</td></tr>
            </xsl:if>
          </tbody>
        </table>

        <xsl:variable name="doc-targets" select=".//publishing[@project = $current-project]/action[source/@type = ('document','publication')][not(source/@document-type)]/target" />
        <xsl:variable name="doc-scripts" select="f:undefined-scripts($project-files//file, 'document', $doc-targets)"/>
        <h2 class="section-title">Document publish</h2>
        <table is="vue:basic-table" zebra="" show-columns="">
          <thead><tr><th class="type">Action type</th><th class="doc">Extension</th><th class="name">Target</th><th class="status">Status</th></tr></thead>
          <tbody>
            <xsl:apply-templates select="$doc-targets" mode="publish-scripts" />
            <xsl:apply-templates select="$doc-scripts" mode="publish-scripts" />
            <xsl:if test="empty($doc-targets | $doc-scripts)">
              <tr><td colspan="4">No document publish scripts are defined</td></tr>
            </xsl:if>
          </tbody>
        </table>

        <xsl:variable name="psml-targets" select=".//publishing[@project = $current-project]/action[source/@document-type]/target" />
        <xsl:variable name="psml-scripts" select="f:undefined-scripts($project-files//file, 'psml', $psml-targets)"/>
        <h2 class="section-title">PSML document type publish</h2>
        <table is="vue:basic-table" zebra="" show-columns="">
          <thead><tr><th class="type">Action type</th><th class="doc">Document type</th><th class="name">Target</th><th class="status">Status</th></tr></thead>
          <tbody>
            <xsl:apply-templates select="$psml-targets" mode="publish-scripts" />
            <xsl:apply-templates select="$psml-scripts" mode="publish-scripts" />
            <xsl:if test="empty($psml-targets | $psml-scripts)">
              <tr><td colspan="4">No PSML document type publish scripts are defined</td></tr>
            </xsl:if>
          </tbody>
        </table>

        <xsl:variable name="url-targets" select=".//publishing[@project = $current-project]/action[source/@type = 'url']/target" />
        <xsl:variable name="url-scripts" select="f:undefined-scripts($project-files//file, 'url', $url-targets)"/>
        <h2 class="section-title">URL publish</h2>
        <table is="vue:basic-table" zebra="" show-columns="">
          <thead><tr><th class="type">Action type</th><th class="doc">URL type</th><th class="name">Target</th><th class="status">Status</th></tr></thead>
          <tbody>
            <xsl:apply-templates select="$url-targets" mode="publish-scripts" />
            <xsl:apply-templates select="$url-scripts" mode="publish-scripts" />
            <xsl:if test="empty($url-targets | $url-scripts)">
              <tr><td colspan="4">No URL publish scripts are defined</td></tr>
            </xsl:if>
          </tbody>
        </table>
      </xsl:otherwise>
    </xsl:choose>
  </main-panel>
  <side-panel side="right" v-bind:width="800"/>
</div>
</xsl:template>

<!--
  display scheduled events in a table
-->
<xsl:template match="event" mode="publish-scripts">
  <tr>
    <td><xsl:value-of select="if (target/description) then concat(target/@name, ' (', target/description, ')') else target/@name" /></td>
    <td>
      <xsl:variable name="ant-script-path" select="concat('/WEB-INF/config/template/', $current-project, '/schedule/build.xml')" />
      <xsl:choose>
        <xsl:when test="//content//file[@path = $ant-script-path]">
          <dropdown-button class="small is-light">
            <file-edit-link project="{$current-project}" location="{$ant-script-path}"
            ><svg-icon name="pencil"/> edit</file-edit-link>
            <template v-slot:menu="">
              <ul>
                <li>
                  <a href="{$site-prefix}/ui/admin/p/{$current-project}/files.html?select={encode-for-uri($ant-script-path)}"
                  ><svg-icon name="folder"/> open folder</a>
                </li>
              </ul>
            </template>
          </dropdown-button>
        </xsl:when>
        <xsl:otherwise>
          <file-edit-link project="{$current-project}" location="{$ant-script-path}"><svg-icon name="plus"/> create</file-edit-link>
        </xsl:otherwise>
      </xsl:choose>
    </td>
  </tr>
</xsl:template>

<!--
  display targets in a table
-->
<xsl:template match="target" mode="publish-scripts">
  <xsl:variable name="project-files" select="//content[@name = 'project-files']" />
  <xsl:variable name="location"      select="f:script-location(.)" />
  <xsl:variable name="path"          select="concat($location, '/build.xml')" />
  <xsl:variable name="exists"        select="$project-files//file[@path = $path]" />
  <tr>
    <td><xsl:value-of select="../@type" /></td>
    <xsl:if test="../source/@type = ('document','publication')">
      <td><xsl:value-of select="if (../source/@document-type) then ../source/@document-type else
                                if (../source/@extension) then ../source/@extension else 'MUST BE CONFIGURED'" /></td>
    </xsl:if>
    <xsl:if test="../source/@type = 'url'">
      <td><xsl:value-of select="if (../source/@url-type) then ../source/@url-type else 'default'" /></td>
    </xsl:if>
    <td>
      <xsl:if test="$exists">
        <svg-icon name="ok" color="auto" />
      </xsl:if>
      <span><xsl:value-of select="@name" /></span>
      <xsl:if test="description"><span class="description"> (<xsl:value-of select="description" />)</span></xsl:if>
      <xsl:if test="../source/@type = 'publication'">
        <xsl:text> </xsl:text><span title="Publication only"><svg-icon name="publication"/></span>
      </xsl:if>
    </td>
    <td>
      <xsl:if test="not(../source/@type = ('document','publication')) or ../source/@document-type or ../source/@extension">
        <xsl:choose>
          <xsl:when test="$exists">
            <dropdown-button class="small is-light">
              <file-edit-link project="{$current-project}" location="{$path}"
              ><svg-icon name="pencil"/> edit </file-edit-link>
              <template v-slot:menu="">
                <ul>
                  <li>
                    <a href="{$site-prefix}/ui/admin/p/{$current-project}/files.html?select={encode-for-uri($path)}"
                    ><svg-icon name="folder"/> open folder</a>
                  </li>
                </ul>
              </template>
            </dropdown-button>
          </xsl:when>
          <xsl:otherwise>
            <file-edit-link project="{$current-project}" location="{$path}"><svg-icon name="plus"/> create</file-edit-link>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:if>
    </td>
  </tr>
</xsl:template>

<!--
  display extra files in a table
-->
<xsl:template match="file" mode="publish-scripts">
  <xsl:variable name="for-url"  select="starts-with(@path, concat('/WEB-INF/config/template/', $current-project, '/url/'))" />
  <xsl:variable name="for-psml" select="starts-with(@path, concat('/WEB-INF/config/template/', $current-project, '/psml/'))" />
  <xsl:variable name="for-doc"  select="starts-with(@path, concat('/WEB-INF/config/template/', $current-project, '/document/'))" />
  <xsl:variable name="elements" select="tokenize(substring-after(@path, concat('/WEB-INF/config/template/', $current-project,
                                        if ($for-url) then '/url/' else if ($for-psml) then '/psml/' else if ($for-doc) then '/document/' else '/')), '/')" />
  <tr>
    <td><xsl:value-of select="$elements[2]" /></td>
    <xsl:if test="$for-url or $for-doc or $for-psml"><td><xsl:value-of select="$elements[1]" /></td></xsl:if>
    <td />
    <td>
      <dropdown-button class="small is-light">
        <file-edit-link project="{$current-project}" location="{@path}"
          ><svg-icon name="pencil"/> not configured</file-edit-link>
        <template v-slot:menu="">
          <ul>
            <li>
              <a href="{$site-prefix}/ui/admin/p/{$current-project}/files.html?select={encode-for-uri(@path)}"
              ><svg-icon name="folder"/> open folder</a>
            </li>
          </ul>
        </template>
      </dropdown-button>
    </td>
  </tr>
</xsl:template>

<xsl:function name="f:undefined-scripts">
  <xsl:param name="files" />
  <xsl:param name="type" />
  <xsl:param name="targets" />
  <xsl:variable name="subtype" select="if ($type = 'document' or $type = 'url' or $type = 'psml') then '[^/]+/' else ''" />
  <xsl:for-each select="$files[matches(@path, concat('/WEB-INF/config/template/', $current-project, '/', $type, '/', $subtype, '(publish|export|import|process|upload|upload-preview)/build\.xml'))]">
    <xsl:if test="empty($targets[concat(f:script-location(.), '/build.xml') = current()/@path])">
      <xsl:sequence select="." />
    </xsl:if>
  </xsl:for-each>
</xsl:function>

<xsl:function name="f:script-location" as="xs:string">
  <xsl:param name="target" />
  <xsl:variable name="location">
    <xsl:text>/WEB-INF/config/template/</xsl:text>
    <xsl:value-of select="$current-project" />
    <xsl:choose>
      <xsl:when test="$target/../source/@url-type">
        <xsl:text>/url/</xsl:text>
        <xsl:value-of select="$target/../source/@url-type" />
      </xsl:when>
      <xsl:when test="$target/../source/@type = 'url'">
        <xsl:text>/url/default</xsl:text>
      </xsl:when>
      <xsl:when test="$target/../source/@document-type">
        <xsl:text>/psml/</xsl:text>
        <xsl:value-of select="$target/../source/@document-type" />
      </xsl:when>
      <xsl:when test="$target/../source/@extension">
        <xsl:text>/document/</xsl:text>
        <xsl:value-of select="$target/../source/@extension" />
      </xsl:when>
      <xsl:otherwise>
        <xsl:text>/</xsl:text>
        <xsl:value-of select="$target/../source/@type" />
      </xsl:otherwise>
    </xsl:choose>
    <xsl:text>/</xsl:text>
    <xsl:value-of select="$target/../@type" />
  </xsl:variable>
  <xsl:value-of select="$location" />
</xsl:function>

</xsl:stylesheet>
