<?xml version="1.0" encoding="UTF-8"?>
<!--
  ~ Copyright (c) 1999-2022. Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:v-bind="https://vuejs.org"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='admin-email']" mode="html-title" as="xs:string*">
  <xsl:sequence select="('Email settings')"/>
</xsl:template>

<xsl:template match="root[@service='admin-email']" mode="main-content">
<div class="main-content">
  <main-panel>
    <h1 class="page-title"><svg-icon name="cog"/> Email settings</h1>
    <xsl:variable name="setup" select="content/setup"/>
    <admin-email initial-email-domain="{$setup/emaildomain}"
                 initial-incoming-disabled="{//alerts/@incoming-email-disabled-message}"
                 initial-address="{$setup/smtpserveraddress}"
                 v-bind:initial-port="{if (string($setup/smtpserverport) = '') then '25' else $setup/smtpserverport}"
                 initial-username="{$setup/smtpserverusername}"
                 v-bind:initial-ssl="{if ($setup/smtpserverssl = 'true') then 'true' else 'false'}"
                 v-bind:initial-starttls="{if ($setup/smtpserverstarttls = 'true') then 'true' else 'false'}" />
  </main-panel>
  <side-panel side="right"/>
</div>
</xsl:template>

</xsl:stylesheet>
