<?xml version="1.0" encoding="UTF-8"?>
<!--
  ~ Copyright (c) 1999-2018 Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:f="http://www.pageseeder.com/function"
                xmlns:v-bind="https://vuejs.org"
                xmlns:json="http://www.w3.org/2005/xpath-functions"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='admin-cache-info']" mode="html-title" as="xs:string*">
  <xsl:sequence select="('Cache information')"/>
</xsl:template>

<xsl:template match="root[@service='admin-cache-info']" mode="main-content">
<div class="main-content">
  <main-panel>
    <xsl:call-template name="current-server-datetime"/>
    <h1 class="page-title"><svg-icon name="system-status"/> Cache information: <em><xsl:value-of select="(content//cache/@name)[1]"/></em></h1>
    <xsl:for-each select="content[@name='get-cache-info']/cache">
      <cache-info v-bind:cache="{f:to-json-cache(.)}"
                  v-bind:config="{f:to-json-cache-config(configuration)}"/>
      <cache-elements cache-name="{@name}" />
    </xsl:for-each>
  </main-panel>
  <side-panel side="right"/>
</div>
</xsl:template>

<xsl:function name="f:to-json-cache-config" as="xs:string">
  <xsl:param name="config" as="element()"/>
  <xsl:variable name="map">
    <json:map>
      <xsl:for-each select="$config/@*">
        <xsl:choose>
          <xsl:when test=". = 'true' or . = 'false'">
            <json:boolean key="{f:camelify(name())}"><xsl:value-of select="."/></json:boolean>
          </xsl:when>
          <xsl:when test=". castable as xs:double">
            <json:number key="{f:camelify(name())}"><xsl:value-of select="."/></json:number>
          </xsl:when>
          <xsl:otherwise>
            <json:string key="{f:camelify(name())}"><xsl:value-of select="."/></json:string>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:for-each>
    </json:map>
  </xsl:variable>
  <xsl:value-of select="json:xml-to-json($map)"/>
</xsl:function>

</xsl:stylesheet>
