<?xml version="1.0" encoding="UTF-8"?>
<!--
  ~ Copyright (c) 1999-2018 Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:v-bind="https://vuejs.org"
                xmlns:f="http://www.pageseeder.com/function"
                xmlns:json="http://www.w3.org/2005/xpath-functions"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='account-project-config']" mode="html-title" as="xs:string*">
  <xsl:sequence select="('Personal config')"/>
</xsl:template>

<xsl:template match="root[@service='account-project-config']" mode="main-content">
<div class="main-content">
  <xsl:variable name="memberid" select="content/context/member/@id" />

  <xsl:variable name="configs">
    <json:array>
      <xsl:apply-templates select="content/member-configs/file" mode="account-project-config-json" />
    </json:array>
  </xsl:variable>

  <xsl:variable name="global-template" select="content/constants/@global-template" />
  <xsl:variable name="docx-configs" select="content/bundles/bundle[@name = 'docx' and @type = 'document']/file" />
  <xsl:variable name="pub-configs"  select="content/bundles/bundle[@name = 'default' and @type = 'publication']/file" />
  <xsl:variable name="defaults">
    <json:array>
      <xsl:apply-templates select="$docx-configs[@definedby = 'default'][@name = 'word-import-config.xml']" mode="account-project-config-json" />
      <xsl:apply-templates select="$docx-configs[@definedby = 'default'][@name = 'psml-split-config.xml']" mode="account-project-config-json" />
      <xsl:apply-templates select="$pub-configs[@definedby = 'default'][@name = 'pdf-export-config.xml']" mode="account-project-config-json" />
      <xsl:apply-templates select="$pub-configs[@definedby = 'default'][@name = 'word-export-config.xml']" mode="account-project-config-json" />
      <xsl:apply-templates select="$pub-configs[@definedby = 'default'][@name = 'word-export-template.docx']" mode="account-project-config-json" />
    </json:array>
  </xsl:variable>
  <xsl:variable name="globals">
    <json:array>
      <xsl:apply-templates select="$docx-configs[@definedby = $global-template][@name = 'word-import-config.xml']" mode="account-project-config-json" />
      <xsl:apply-templates select="$docx-configs[@definedby = $global-template][@name = 'psml-split-config.xml']" mode="account-project-config-json" />
      <xsl:apply-templates select="$pub-configs[@definedby = $global-template][@name = 'pdf-export-config.xml']" mode="account-project-config-json" />
      <xsl:apply-templates select="$pub-configs[@definedby = $global-template][@name = 'word-export-config.xml']" mode="account-project-config-json" />
      <xsl:apply-templates select="$pub-configs[@definedby = $global-template][@name = 'word-export-template.docx']" mode="account-project-config-json" />
    </json:array>
  </xsl:variable>
  <xsl:variable name="projects">
    <json:array>
      <xsl:apply-templates select="$docx-configs[@definedby != 'default' and @definedby != $global-template][@name = 'word-import-config.xml']" mode="account-project-config-json" />
      <xsl:apply-templates select="$docx-configs[@definedby != 'default' and @definedby != $global-template][@name = 'psml-split-config.xml']" mode="account-project-config-json" />
      <xsl:apply-templates select="$pub-configs[@definedby != 'default' and @definedby != $global-template][@name = 'pdf-export-config.xml']" mode="account-project-config-json" />
      <xsl:apply-templates select="$pub-configs[@definedby != 'default' and @definedby != $global-template][@name = 'word-export-config.xml']" mode="account-project-config-json" />
      <xsl:apply-templates select="$pub-configs[@definedby != 'default' and @definedby != $global-template][@name = 'word-export-template.docx']" mode="account-project-config-json" />
    </json:array>
  </xsl:variable>

  <main-panel>
    <h1 class="page-title">Member publish configurations for project <xsl:value-of select="$current-project" /></h1>

    <account-project-config member-id="{$memberid}" project="{$current-project}"
                            v-bind:default-configs="{f:xml-to-json($defaults)}"
                            v-bind:global-configs="{f:xml-to-json($globals)}"
                            v-bind:project-configs="{f:xml-to-json($projects)}"
                            v-bind:initial-configs="{f:xml-to-json($configs)}" />
  </main-panel>
  <side-panel side="right" v-bind:width="800"/>
</div>
</xsl:template>

<!-- Returns the file as JSON -->
<xsl:template match="file" mode="account-project-config-json">
  <xsl:if test="not(@status = 'not-found')">
    <json:map>
      <json:string key="name"><xsl:value-of select="@name"/></json:string>
      <json:string key="type"><xsl:value-of select="@type"/></json:string>
      <json:string key="path"><xsl:value-of select="@path"/></json:string>
      <json:number key="length"><xsl:value-of select="if (@length) then @length else 0"/></json:number>
      <json:string key="mediatype"><xsl:value-of select="@mediatype"/></json:string>
      <json:string key="modified"><xsl:value-of select="@modified"/></json:string>
      <json:string key="definedby"><xsl:value-of select="@definedby"/></json:string>
      <json:string key="role"><xsl:value-of select="@role"/></json:string>
      <json:boolean key="text"><xsl:value-of select="@text = 'true'"/></json:boolean>
      <json:boolean key="editable"><xsl:value-of select="@editable = 'true'"/></json:boolean>
    </json:map>
  </xsl:if>
</xsl:template>


</xsl:stylesheet>
