<?xml version="1.0" encoding="UTF-8"?>
<!--
  ~ Copyright (c) 1999-2020 Allette Systems Pty Ltd
-->
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='account-memberships']" mode="html-title" as="xs:string*">
  <xsl:sequence select="('Groups')"/>
</xsl:template>

<xsl:template match="root[@service='account-memberships']" mode="main-content">
<xsl:variable name="group" select="header/http-parameters/parameter[@name = 'group']" />
<div class="main-content">
  <main-panel>
    <h1 class="page-title"><svg-icon name="member-groups"/> My groups</h1>

    <xsl:for-each select="$session/member">
      <account-groups>
        <xsl:if test="$group">
          <xsl:attribute name="self-registration-group"><xsl:value-of select="$group" /></xsl:attribute>
        </xsl:if>
      </account-groups>
    </xsl:for-each>

  </main-panel>
  <side-panel side="right"/>
</div>
</xsl:template>

</xsl:stylesheet>
