<?xml version="1.0"?>
<!--
  Template used for the daily digest notification

  @version 5.9904
-->
<xsl:stylesheet version="2.0"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:f="http://www.pageseeder.com/function"
                exclude-result-prefixes="#all">

<xsl:import href="_frame.xsl"/>

<!-- Subject and metadata -->
<xsl:template match="notification[@template='reminder-digest']" mode="meta">
  <title><xsl:value-of select="$appname" /><xsl:text> </xsl:text>
    <xsl:value-of select="f:hostname($homepage)"/> reminders</title>
</xsl:template>

<!-- Body content -->
<xsl:template match="notification[@template='reminder-digest']" mode="banner">
  <p wrapper-class="digest-wrap">Hi <xsl:value-of select="//comment[1]/assignedto/@firstname"
     />, here are your task/workflow reminders for
  <b><xsl:value-of select="format-date(current-date(), '[D] [MNn] [Y0001]')"/></b></p>
</xsl:template>

<!-- Body content -->
<xsl:template match="notification[@template='reminder-digest']" mode="body">
  <xsl:apply-templates select="comments" mode="reminder-html" />
</xsl:template>

<!-- ===================================================================================== -->
<!-- Comments -->
<!-- ===================================================================================== -->

<xsl:template match="comments" mode="reminder-html">
  <div class="reminder-summary">
    <xsl:if test="@limitreached='true'">
      <p>There are too many reminders to list. To see all your tasks visit <a href="{$linksprefix}/mytasks">my tasks &amp; workflows</a>.</p>
    </xsl:if>
    <xsl:if test="comment[@contentrole!='Workflow']">
      <p><b>Tasks</b></p>
      <table cellspacing="0" cellpadding="0">
        <tr>
          <th style="width: 55%">Task</th>
          <th style="width: 15%" class="reminder-nobreak">Priority</th>
          <th style="width: 15%" class="reminder-nobreak">Status</th>
          <th style="width: 15%" class="reminder-nobreak">Due</th>
        </tr>
        <xsl:apply-templates select="comment[@contentrole!='Workflow']" mode="reminder-html">
          <xsl:sort select="@due"/>
        </xsl:apply-templates>
      </table>
    </xsl:if>
    <xsl:if test="comment[@contentrole='Workflow']">
      <p><b>Workflows</b></p>
      <table cellspacing="0" cellpadding="0">
        <tr>
          <th style="width: 55%">Document</th>
          <th style="width: 15%" class="reminder-nobreak">Priority</th>
          <th style="width: 15%" class="reminder-nobreak">Status</th>
          <th style="width: 15%" class="reminder-nobreak">Due</th>
        </tr>
        <xsl:apply-templates select="comment[@contentrole='Workflow']" mode="reminder-html">
          <xsl:sort select="@due"/>
        </xsl:apply-templates>
      </table>
    </xsl:if>
  </div>

  <p class="timezone">Dates and times display for timezone <xsl:value-of select="format-date(current-date(), '[z]')"/></p>
</xsl:template>

<xsl:template match="comment" mode="reminder-html">
  <tr>
    <td>
      <div class="reminder-title">
        <xsl:choose>
          <xsl:when test="@contentrole='Workflow'">
            <xsl:sequence select="f:link(concat($linksprefix, '/workflow?group=', group/@name, '&amp;uri=', context/uri/@id), title)"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:sequence select="f:link(concat($linksprefix, '/comment?group=', group/@name, '&amp;comment=', @id), title)"/>
          </xsl:otherwise>
        </xsl:choose>
      </div>
      <div class="reminder-group"><xsl:value-of select="group/@name" /></div>
    </td>
    <td class="reminder-nobreak">
      <img src="{$images-url}/{f:priority-icon(@priority)}" class="is-task-icon" width="16"  border="0" alt="{@priority}" />
      <xsl:text> </xsl:text>
      <xsl:value-of select="@priority" />
    </td>
    <td class="reminder-nobreak">
      <xsl:value-of select="@status" />
    </td>
    <td class="reminder-nobreak">
      <xsl:choose>
        <xsl:when test="year-from-dateTime(@due) = year-from-date(current-date())">
          <xsl:value-of select="format-dateTime(@due, '[FNn,*-3] [D] [MNn,*-3]')" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="format-dateTime(@due, '[MNn,*-3] [Y0001]')" />
        </xsl:otherwise>
      </xsl:choose>
      <xsl:choose>
        <xsl:when test="xs:dateTime(@due) lt current-dateTime()">
          <div><span class="reminder-overdue">Overdue</span></div>
        </xsl:when>
        <xsl:when test="xs:dateTime(@due) lt (current-dateTime() + xs:dayTimeDuration('P3D'))">
          <div><span class="reminder-duesoon">Due soon</span></div>
        </xsl:when>
      </xsl:choose>
    </td>
  </tr>
</xsl:template>

<!-- Footer -->
<xsl:template match="notification[@template='reminder-digest']" mode="footer">
  <xsl:call-template name="noreply"/>
  <p>You received this message because you have an account on
    <a href="{$homepage}"><xsl:value-of select="f:hostname($homepage)"/></a>.
  Manage your ongoing  notification settings using your <a href="{$linksprefix}/mygroups">group options</a>.</p>
  <xsl:if test="organization/footer/@text">
    <p><xsl:value-of select="organization/footer/@text"/></p>
  </xsl:if>
</xsl:template>

<!--
  Find the name of the icon corresponding to the priority provided

  @param priority the priority

  @param the filename of the icon
 -->
<xsl:function name="f:priority-icon">
  <xsl:param name="priority"/>
  <xsl:choose>
    <xsl:when test="lower-case($priority) = 'high'">task-priority-1.png</xsl:when>
    <xsl:when test="lower-case($priority) = 'medium'">task-priority-2.png</xsl:when>
    <xsl:when test="lower-case($priority) = 'low'">task-priority-3.png</xsl:when>
    <xsl:otherwise>task-priority-4.png</xsl:otherwise>
  </xsl:choose>
</xsl:function>

</xsl:stylesheet>
