<?xml version="1.0"?>
<!--
  Template used when a member has been invited

  @version 5.9904
-->
<xsl:stylesheet version="2.0"
        xmlns:f="http://www.pageseeder.com/function"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        exclude-result-prefixes="#all">

<xsl:import href="_frame.xsl"/>

<!-- Subject and metadata -->
<xsl:template match="notification[@template='membership-confirm']" mode="meta">
  <title>[<xsl:value-of select="membership/(group|project)/@name" />] <xsl:value-of select=" if (membership/project) then 'Project' else 'Group'"/> invitation</title>
</xsl:template>

<!-- Banner -->
<xsl:template match="notification[@template='membership-confirm']" mode="banner">
  <p wrapper-class="membership-wrap"><xsl:value-of select="$appname" /> group invitation</p>
</xsl:template>

<!-- Body content -->
<xsl:template match="notification[@template='membership-confirm']" mode="body">

  <h3>Hi <xsl:value-of select="membership/member/@firstname" />,</h3>

  <p class="lead">
  <xsl:choose>
    <xsl:when test="inviter"><b><xsl:value-of select="inviter/fullname"/></b> has invited you</xsl:when>
    <xsl:otherwise>You have been invited</xsl:otherwise>
  </xsl:choose> to join the <xsl:value-of select="if (membership/project) then 'project ' else 'group '"/>
  <b><xsl:value-of select="membership/(group|project)/@name" /></b> .
  </p>

  <xsl:call-template name="table">
    <xsl:with-param name="title-image">ico-group.png</xsl:with-param>
    <xsl:with-param name="title" select="membership/(group|project)/@name" />
    <xsl:with-param name="rows">
      <rows xmlns="">
        <row title="{if (membership/project) then 'Project' else 'Group'} title"><xsl:value-of select="f:group-title(membership/(group|project))" /></row>
        <row title="Description"><xsl:value-of select="membership/(group|project)/@description" /></row>
      </rows>
    </xsl:with-param>
  </xsl:call-template>

  <!-- Copy the welcome message -->
  <xsl:if test="membership/(group|project)/message">
    <p><xsl:copy-of select="f:text-to-html(membership/(group|project)/message)" /></p>
  </xsl:if>

  <xsl:sequence select="f:button(concat($linksprefix, '/myinvitation?group=', membership/(group|project)/@name), 'Accept the invitation')"/>

  <p class="last">Disregard this email, if you do not wish to join.</p>
</xsl:template>

<!-- Footer -->
<xsl:template match="notification[@template='membership-confirm']" mode="footer">
  <xsl:call-template name="noreply"/>
  <xsl:variable name="group" select="membership/(group|project)"/>
  <p>You have received this email because a <xsl:value-of select="$appname" /> member invited you to join group <i><xsl:value-of select="$group/@name" /></i>
  on <a href="{$homepage}"><xsl:value-of select="f:hostname($homepage)"/></a>.</p>
  <xsl:if test="organization/footer/@text">
    <p><xsl:value-of select="organization/footer/@text"/></p>
  </xsl:if>
</xsl:template>

</xsl:stylesheet>
