<?xml version="1.0"?>
<!--
  This stylesheet provides a set of common templates and functions for use by the email templates.

  Note: This module defines legacy templates that should be gradually replaced.
-->
<xsl:stylesheet version="2.0"
        xmlns:f="http://www.pageseeder.com/function"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        exclude-result-prefixes="f">

<!-- ===================================================================================== -->
<!-- Enclosed Message                                                                      -->
<!-- ===================================================================================== -->
<xsl:template name="message">
  <xsl:param name="subject" />
  <xsl:param name="author" />
  <xsl:param name="content" />
  <xsl:param name="uri" />
  <xsl:param name="attachments" />
  <table cellspacing="0" cellpadding="0" class="ps-message">
    <thead>
      <tr>
        <th class="ps-message_head-left"><img src="{$images-url}/ico-comment.png" border="0" class="is-icon" width="20"/></th>
        <th class="ps-message_head-right">Original message</th>
      </tr>
    </thead>
    <tbody>
      <tr>
        <th class="ps-message_th">Subject:</th>
        <td class="ps-message_td"><xsl:value-of select="$subject" /></td>
      </tr>
      <xsl:if test="$author">
        <tr>
          <th class="ps-message_th">Author:</th>
          <td class="ps-message_td"><xsl:value-of select="$author" /> (<xsl:value-of select="$author/@email"/>)</td>
        </tr>
      </xsl:if>
      <xsl:if test="$uri">
        <tr>
          <th class="ps-message_th">Document:</th>
          <td class="ps-message_td">
            <img src="{$images-url}/{f:mediatype-icon($uri)}" border="0" alt="" height="16" width="16" style="vertical-align:bottom" />
            <xsl:sequence select="f:link(concat($linksprefix, '/uri?group=', /notification/group/@name, '&amp;uri=', $uri/@id), $uri/displaytitle)" />
          </td>
        </tr>
      </xsl:if>
      <xsl:if test="$attachments">
        <tr>
          <th class="ps-message_th">Attachment<xsl:value-of select="if (count($attachments) > 1) then 's' else ''" />:</th>
          <td class="ps-message_td">
            <xsl:for-each select="$attachments">
              <img src="{$images-url}/{f:mediatype-icon(.)}" border="0" alt="" height="16" width="16" style="vertical-align:bottom"/>
              <xsl:sequence select="f:link(concat($linksprefix, '/uri?group=', /notification/group/@name, '&amp;uri=', @id), displaytitle)" />
              <br/>
            </xsl:for-each>
          </td>
        </tr>
      </xsl:if>
      <tr>
        <th class="ps-message_th">Content:</th>
        <td class="ps-message_td">
          <xsl:if test="$content">
            <xsl:analyze-string select="$content" regex="\n" flags="m">
              <xsl:matching-substring><br/></xsl:matching-substring>
              <xsl:non-matching-substring><xsl:value-of select="." /></xsl:non-matching-substring>
            </xsl:analyze-string>
          </xsl:if>
        </td>
     </tr>
    </tbody>
  </table>
</xsl:template>

<!-- ===================================================================================== -->
<!-- Inside Table                                                                          -->
<!--  (icon, width, title and rows may change)                                             -->
<!-- ===================================================================================== -->
<xsl:template name="table">
  <xsl:param name="table-style" select="''" />
  <xsl:param name="title-image">ico-member.png</xsl:param>
  <xsl:param name="title" />
  <xsl:param name="rows" />

  <table cellspacing="0" cellpadding="0" class="ps-table" style="{$table-style}">
    <thead>
      <tr>
        <!-- Icon: Same image, different vertical position -->
        <th class="ps-table_head-left"><img src="{$images-url}/{$title-image}" class="is-icon" border="0" /></th>
        <th class="ps-table_head-right"><xsl:value-of select="$title" /></th>
      </tr>
    </thead>
    <tbody>
      <xsl:for-each select="$rows//row">
        <tr>
          <th class="ps-table_th"><xsl:value-of select="@title" />:</th>
          <td class="ps-table_td"><xsl:sequence select="node()" /></td>
        </tr>
      </xsl:for-each>
    </tbody>
  </table>
</xsl:template>

</xsl:stylesheet>