update client set scopes = concat(scopes, ' all') where scopes is not null;

update client set scopes = 'all' where scopes is null;

drop table uri_for_uri;

alter table member
    drop constraint member_username_key,
    drop constraint member_email_key;

create unique index member_username_key on member (lower(username));

create unique index member_email_key on member (lower(email));

alter table dgroupuri
    drop constraint dgroupuri_scheme_hostid_port_path_key;

create unique index dgroupuri_key on dgroupuri (scheme,hostid,port,lower(path));

alter table uri
    drop title,
    add  pathhash bytea null,
    drop constraint uri_scheme_hostid_port_path_key;

update uri u
    set pathhash = sha256(convert_to(u.path, 'LATIN1'))
    from host h where u.hostid = h.hostid
    and u.path is not null
    and (h.externalflag = '1' or u.path not like '/ps/%');

update uri u
    set pathhash = bytea E'\\x00'
    from host h where u.hostid = h.hostid
    and (h.externalflag is null or h.externalflag = '0') and u.path like '/ps/%';

create unique index uri_key on uri (scheme,hostid,port,lower(path),pathhash);

create index usertitle_idx on uri(usertitle);

alter table dgroup
    drop abbreviation,
    drop siteformat,
    drop precedence,
    drop commentsmodified,
    drop urismodified,
    drop xrefsmodified;

alter table host
    alter column name type varchar(255);

alter table hostalias
    alter column name type varchar(255);

update database_metadata set version='6.10';