ALTER TABLE DGROUPURI_FOR_DGROUP
  ADD FOREIGN KEY (GroupURIID) REFERENCES DGROUPURI(GroupURIID),
  ADD FOREIGN KEY (GroupID) REFERENCES DGROUP(GroupID);

ALTER TABLE XLINK_FOR_XLINK
  ADD FOREIGN KEY (ReplyToID) REFERENCES XLINK(XLinkID),
  ADD FOREIGN KEY (ReplyID) REFERENCES XLINK(XLinkID);

ALTER TABLE URI_FOR_DGROUPURI
  ADD FOREIGN KEY (GroupURIID) REFERENCES DGROUPURI(GroupURIID),
  ADD FOREIGN KEY (URIID) REFERENCES URI(URIID);

ALTER TABLE MEMBER
  ADD EmailDomain VARCHAR(100) NULL;

UPDATE MEMBER set EmailDomain = RIGHT(Email, LENGTH(Email) - LOCATE('@', Email));

CREATE INDEX EmailDomain_idx ON MEMBER(EmailDomain);

ALTER TABLE CLIENT
  ADD WebhookSecret  VARCHAR(64) NULL,
  ADD DateCreated    DATETIME(3) NULL,
  ADD DateModified   DATETIME(3) NULL,
  ADD DateLastToken  DATETIME(3) NULL,
  ADD AppName        VARCHAR(32) NULL;

CREATE TABLE WEBHOOK (
  WebhookID       INTEGER AUTO_INCREMENT PRIMARY KEY,
  ClientID        INTEGER NOT NULL,
  DateCreated     DATETIME(3)  NOT NULL,
  DateModified    DATETIME(3)  NOT NULL,
  Name            VARCHAR(64)  NULL,
  URL             VARCHAR(255) NOT NULL,
  Server          TINYINT      NOT NULL,
  Projects        VARCHAR(255) NULL,
  `Groups`        VARCHAR(255) NULL,
  Events          VARCHAR(500) NULL,
  Object          VARCHAR(10)  NOT NULL,
  Format          VARCHAR(5)   NOT NULL,
  InsecureSSL     TINYINT      NOT NULL,
  Status          VARCHAR(15)  NOT NULL,
    UNIQUE KEY Name_key (Name),
    FOREIGN KEY (ClientID) REFERENCES CLIENT(ClientID)
  ) ENGINE = InnoDB, CHARACTER SET utf8;

UPDATE DATABASE_METADATA SET Version='5.95';