CREATE TABLE LOCATOR(
        LocatorID INTEGER AUTO_INCREMENT PRIMARY KEY,
        Fragment VARCHAR(250) NULL,
        Accepted TINYINT NOT NULL,
        Behavior VARCHAR(80) NULL,
        URIID INTEGER NULL,
            UNIQUE KEY Locator_key (URIID,Fragment)
        ) ENGINE = InnoDB, CHARACTER SET utf8mb4;

CREATE TABLE DGROUP(
        GroupID INTEGER AUTO_INCREMENT PRIMARY KEY,
        GroupName VARCHAR(60) NULL,
        GroupDesc VARCHAR(250) NULL,
        DefaultLocatorID INTEGER NULL,
        ControlGroupName VARCHAR(60) NULL,
        DetailsForm VARCHAR(150) NULL,
        Owner VARCHAR(100) NULL,
        Message TEXT NULL,
        Flags VARCHAR(20) NULL,
        OwnerDirectory VARCHAR(60) NULL,
        HomeURL VARCHAR(250) NULL,
        Title VARCHAR(100) NULL,
        IndexVersion INTEGER NULL,
            FOREIGN KEY (DefaultLocatorID) REFERENCES LOCATOR(LocatorID),
            UNIQUE KEY GroupName_key (GroupName)
        ) ENGINE = InnoDB, CHARACTER SET utf8mb4;

CREATE TABLE HOST(
        HostID INTEGER AUTO_INCREMENT PRIMARY KEY,
        Name VARCHAR(255) NULL,
        ExternalFlag TINYINT NULL,
        VirtualFlag TINYINT NULL,
            UNIQUE KEY HostName_key (Name)
        ) ENGINE = InnoDB, CHARACTER SET utf8mb4;

CREATE TABLE MEMBER(
        MemberID INTEGER AUTO_INCREMENT PRIMARY KEY,
        FirstName VARCHAR(50) NULL,
        Surname VARCHAR(50) NULL,
        Email VARCHAR(100) NULL,
        Username VARCHAR(100) NULL,
        Password VARCHAR(100) NULL,
        SubmitPref VARCHAR(20) NULL,
        BounceReceived INTEGER NULL,
        ExternalUserID VARCHAR(100) NULL,
        Created DATETIME(3) NULL,
        Activated DATETIME(3) NULL,
        LastLogin DATETIME(3) NULL,
        LastPasswordChange DATETIME(3) NULL,
        EmailDomain VARCHAR(100) NULL,
            UNIQUE KEY Username_key (Username),
            UNIQUE KEY Email_key (Email)
        ) ENGINE = InnoDB, CHARACTER SET utf8mb4;

CREATE TABLE MEMBER_GROUP_DETAILS(
        MemberGroupDetailsID INTEGER AUTO_INCREMENT PRIMARY KEY,
        Field1 VARCHAR(100) NULL,
        Field2 VARCHAR(100) NULL,
        Field3 VARCHAR(100) NULL,
        Field4 VARCHAR(100) NULL,
        Field5 VARCHAR(100) NULL,
        Field6 VARCHAR(100) NULL,
        Field7 VARCHAR(100) NULL,
        Field8 VARCHAR(100) NULL,
        Field9 VARCHAR(100) NULL,
        Field10 VARCHAR(100) NULL,
        Field11 VARCHAR(100) NULL,
        Field12 VARCHAR(100) NULL,
        Field13 VARCHAR(100) NULL,
        Field14 VARCHAR(100) NULL,
        Field15 VARCHAR(100) NULL
        ) ENGINE = InnoDB, CHARACTER SET utf8mb4;

CREATE TABLE XLINK(
        XLinkID INTEGER AUTO_INCREMENT PRIMARY KEY,
        Accepted TINYINT NOT NULL,
        ModeratorOnly TINYINT NOT NULL,
        ContentRole VARCHAR(250) NULL,
        ContentTitle VARCHAR(250) CHARACTER SET utf8mb4 NULL,
        AuthorName VARCHAR(100) NULL,
        AuthorEmail VARCHAR(100) NULL,
        MemberID INTEGER NULL,
        CreationDate DATETIME(3) NULL,
        ModeratorID INTEGER NULL,
        AuthorOnly TINYINT NOT NULL,
        ExternalUserID VARCHAR(100) NULL,
        Properties TEXT CHARACTER SET utf8mb4 NULL,
        ModifiedDate DATETIME(3) NULL,
        StatusChangedDate DATETIME(3) NULL,
        StatusChangedByID INTEGER NULL,
        Status VARCHAR(40) NULL,
        AssignedToID INTEGER NULL,
        AssignedDate DATETIME(3) NULL,
        DueDate DATETIME(3) NULL,
        Priority VARCHAR(40) NULL,
        Type VARCHAR(250) NULL,
        ThreadEndXLinkID INTEGER NULL,
            FOREIGN KEY (ThreadEndXLinkID) REFERENCES XLINK(XLinkID),
            FOREIGN KEY (MemberID) REFERENCES MEMBER(MemberID),
            FOREIGN KEY (ModeratorID) REFERENCES MEMBER(MemberID),
            FOREIGN KEY (StatusChangedByID) REFERENCES MEMBER(MemberID),
            FOREIGN KEY (AssignedToID) REFERENCES MEMBER(MemberID)
        ) ENGINE = InnoDB, CHARACTER SET utf8mb4;

CREATE TABLE URI(
        URIID INTEGER AUTO_INCREMENT PRIMARY KEY,
        DocID VARCHAR(100) NULL,
        Scheme VARCHAR(20) CHARACTER SET ascii NULL,
        Path VARCHAR(500) CHARACTER SET ascii NULL,
        ParentPath VARCHAR(500) CHARACTER SET ascii NULL,
        HostID INTEGER NULL,
        Port INTEGER NULL,
        Behavior VARCHAR(80) NULL,
        LastModified DATETIME(3) NULL,
        Description TEXT CHARACTER SET utf8mb4 NULL,
        DateCreated DATETIME(3) NULL,
        DateArchived DATETIME(3) NULL,
        XLinkID INTEGER NULL,
        UserTitle VARCHAR(250) CHARACTER SET utf8mb4 NULL,
        Type VARCHAR(100) NULL,
        Labels VARCHAR(250) NULL,
        Size BIGINT NULL,
        Archived TINYINT NULL,
        Folder TINYINT NULL,
        DraftEditXLinkID INTEGER NULL,
        PathHash BINARY(32) NULL,
            FOREIGN KEY (HostID) REFERENCES HOST(HostID),
            FOREIGN KEY (XLinkID) REFERENCES XLINK(XLinkID),
            FOREIGN KEY (DraftEditXLinkID) REFERENCES XLINK(XLinkID),
            UNIQUE KEY URI_key (Scheme,HostID,Port,Path,PathHash)
        ) ENGINE = InnoDB, CHARACTER SET utf8mb4;

ALTER TABLE LOCATOR
  ADD FOREIGN KEY (URIID) REFERENCES URI(URIID);

CREATE TABLE MODERATOR(
        ModeratorID INTEGER AUTO_INCREMENT PRIMARY KEY,
        Quota INTEGER NULL,
        QuotaReceived INTEGER NULL
        ) ENGINE = InnoDB, CHARACTER SET utf8mb4;

CREATE TABLE DGROUPURI(
        GroupURIID INTEGER AUTO_INCREMENT PRIMARY KEY,
        Scheme VARCHAR(20) CHARACTER SET ascii NULL,
        Path VARCHAR(250) CHARACTER SET ascii NULL,
        HostID INTEGER NULL,
        Port INTEGER NULL,
            FOREIGN KEY (HostID) REFERENCES HOST(HostID),
            UNIQUE KEY GroupURI_key (Scheme,HostID,Port,Path)
        ) ENGINE = InnoDB, CHARACTER SET utf8mb4;

CREATE TABLE URI_FOR_DGROUPURI(
        GroupURIID INTEGER NOT NULL,
        URIID INTEGER NOT NULL,
            FOREIGN KEY (GroupURIID) REFERENCES DGROUPURI(GroupURIID),
            FOREIGN KEY (URIID) REFERENCES URI(URIID)
        ) ENGINE = InnoDB, CHARACTER SET utf8mb4;

CREATE TABLE MEMBER_FOR_DGROUP(
        MemberForGroupID INTEGER AUTO_INCREMENT PRIMARY KEY,
        Listed TINYINT NOT NULL,
        Notification VARCHAR(20) NULL,
        GroupID INTEGER NOT NULL,
        MemberID INTEGER NULL,
        ModeratorID INTEGER NULL,
        Editor TINYINT NOT NULL,
        MemberGroupDetailsID INTEGER NULL,
        Created DATETIME(3) NULL,
        EditorFlags VARCHAR(20) NULL,
            FOREIGN KEY (GroupID) REFERENCES DGROUP(GroupID),
            FOREIGN KEY (MemberID) REFERENCES MEMBER(MemberID),
            FOREIGN KEY (ModeratorID) REFERENCES MODERATOR(ModeratorID),
            FOREIGN KEY (MemberGroupDetailsID) REFERENCES MEMBER_GROUP_DETAILS(MemberGroupDetailsID),
            UNIQUE KEY MemberForGroup_key (GroupID,MemberID)
        ) ENGINE = InnoDB, CHARACTER SET utf8mb4;

CREATE TABLE DGROUPURI_FOR_DGROUP(
        GroupURIForGroupID INTEGER AUTO_INCREMENT PRIMARY KEY,
        GroupID INTEGER NOT NULL,
        GroupURIID INTEGER NOT NULL,
        EditURIs TINYINT NULL,
            UNIQUE KEY GroupURIForGroup_key (GroupID,GroupURIID),
            FOREIGN KEY (GroupURIID) REFERENCES DGROUPURI(GroupURIID),
            FOREIGN KEY (GroupID) REFERENCES DGROUP(GroupID)
        ) ENGINE = InnoDB, CHARACTER SET utf8mb4;

CREATE TABLE XLINK_FOR_XLINK(
        ReplyToID INTEGER NOT NULL,
        ReplyID INTEGER NOT NULL,
            FOREIGN KEY (ReplyToID) REFERENCES XLINK(XLinkID),
            FOREIGN KEY (ReplyID) REFERENCES XLINK(XLinkID)
        ) ENGINE = InnoDB, CHARACTER SET utf8mb4;

CREATE TABLE HOSTALIAS(
        HostAliasID INTEGER AUTO_INCREMENT PRIMARY KEY,
        Name VARCHAR(255) NULL,
        HostID INTEGER NOT NULL,
            FOREIGN KEY (HostID) REFERENCES HOST(HostID),
            UNIQUE KEY HostAliasName_key (Name)
        ) ENGINE = InnoDB, CHARACTER SET utf8mb4;

CREATE TABLE CONTENT(
        ContentID INTEGER AUTO_INCREMENT PRIMARY KEY,
        Type VARCHAR(100) NULL,
        Data LONGTEXT CHARACTER SET utf8mb4 NULL,
        XLinkID INTEGER NOT NULL,
        BinaryData MEDIUMBLOB NULL,
            FOREIGN KEY (XLinkID) REFERENCES XLINK(XLinkID)
        ) ENGINE = InnoDB, CHARACTER SET utf8mb4;

CREATE TABLE LOCATOR_FOR_XLINK(
        LocatorForXLinkID INTEGER AUTO_INCREMENT PRIMARY KEY,
        Role VARCHAR(250) NULL,
        Title VARCHAR(250) NULL,
        LocatorID INTEGER NOT NULL,
        XLinkID INTEGER NULL,
        Label VARCHAR(100) NULL,
        ContentID INTEGER NULL,
            FOREIGN KEY (LocatorID) REFERENCES LOCATOR(LocatorID),
            FOREIGN KEY (XLinkID) REFERENCES XLINK(XLinkID),
            FOREIGN KEY (ContentID) REFERENCES CONTENT(ContentID)
        ) ENGINE = InnoDB, CHARACTER SET utf8mb4;

CREATE TABLE DGROUP_FOR_XLINK(
        GroupForXLinkID INTEGER AUTO_INCREMENT PRIMARY KEY,
        XLinkID INTEGER NOT NULL,
        GroupID INTEGER NULL,
            FOREIGN KEY (XLinkID) REFERENCES XLINK(XLinkID),
            FOREIGN KEY (GroupID) REFERENCES DGROUP(GroupID),
            UNIQUE KEY GroupID_XLinkID_key (GroupID, XLinkID)
        ) ENGINE = InnoDB, CHARACTER SET utf8mb4;

CREATE TABLE DGROUP_FOR_DGROUP(
    GroupForGroupID INTEGER AUTO_INCREMENT PRIMARY KEY,
    GroupID INTEGER NOT NULL,
    MemberGroupID INTEGER NOT NULL,
    Listed TINYINT NULL,
    Notification VARCHAR(20) NULL,
    RoleFlags VARCHAR(20) NULL,
        FOREIGN KEY (GroupID) REFERENCES DGROUP(GroupID),
        FOREIGN KEY (MemberGroupID) REFERENCES DGROUP(GroupID),
        UNIQUE KEY GroupForGroup_key (GroupID,MemberGroupID)
    ) ENGINE = InnoDB, CHARACTER SET utf8mb4;

CREATE TABLE XLINK_FOR_ATTACHEDXLINK(
    XLinkForAttachedXLinkID INTEGER AUTO_INCREMENT PRIMARY KEY,
    XLinkID INTEGER NOT NULL,
    AttachedXLinkID INTEGER NOT NULL,
    Role VARCHAR(250) NULL,
        FOREIGN KEY (XLinkID) REFERENCES XLINK(XLinkID),
        FOREIGN KEY (AttachedXLinkID) REFERENCES XLINK(XLinkID)
    ) ENGINE = InnoDB, CHARACTER SET utf8mb4;

CREATE TABLE CLIENT(
    ClientID            INTEGER AUTO_INCREMENT PRIMARY KEY,
    Name                VARCHAR(255) NULL,
    Identifier          VARCHAR(16)  NULL,
    SecretHash          VARCHAR(64)  NULL,
    GrantType           VARCHAR(20)  NULL,
    RedirectURI         VARCHAR(255) NULL,
    ClientURI           VARCHAR(255) NULL,
    RequireConsent      TINYINT      NULL,
    Confidential        TINYINT      NULL,
    AccessTokenMaxAge   INTEGER      NULL,
    RefreshTokenMaxAge  INTEGER      NULL,
    Scopes              VARCHAR(255) NULL,
    MemberID            INTEGER      NULL,
    Description         VARCHAR(255) NULL,
    WebhookSecret       VARCHAR(64)  NULL,
    DateCreated         DATETIME(3)  NULL,
    DateModified        DATETIME(3)  NULL,
    DateLastToken       DATETIME(3)  NULL,
    AppName             VARCHAR(32)  NULL,
        UNIQUE KEY Identifier_key (Identifier),
        UNIQUE KEY Name_key (Name),
        INDEX Name_idx (Name),
        INDEX Identifier_idx (Identifier),
        FOREIGN KEY (MemberID) REFERENCES MEMBER(MemberID)
    ) ENGINE = InnoDB, CHARACTER SET utf8mb4;

CREATE TABLE PERSISTENT_TOKEN(
    TokenID     INTEGER AUTO_INCREMENT PRIMARY KEY,
    TokenHash   VARCHAR(50)   NULL,
    MemberID    INTEGER       NULL,
    ClientID    INTEGER       NULL,
    DateIssued  DATETIME(3)   NULL,
    DateExpires DATETIME (3)  NULL,
    Scopes      VARCHAR (255) NULL,
    Data        VARCHAR (255) NULL,
        INDEX TokenHash_idx (TokenHash),
        FOREIGN KEY (ClientID) REFERENCES CLIENT(ClientID),
        FOREIGN KEY (MemberID) REFERENCES MEMBER(MemberID)
    ) ENGINE = InnoDB, CHARACTER SET utf8mb4;

CREATE TABLE WEBHOOK (
    WebhookID       INTEGER AUTO_INCREMENT PRIMARY KEY,
    ClientID        INTEGER NOT NULL,
    DateCreated     DATETIME(3)  NOT NULL,
    DateModified    DATETIME(3)  NOT NULL,
    Name            VARCHAR(64)  NULL,
    URL             VARCHAR(255) NOT NULL,
    Server          TINYINT      NOT NULL,
    Projects        VARCHAR(255) NULL,
    `Groups`        VARCHAR(255) NULL,
    Events          VARCHAR(500) NULL,
    Object          VARCHAR(10)  NOT NULL,
    Format          VARCHAR(5)   NOT NULL,
    InsecureSSL     TINYINT      NOT NULL,
    Status          VARCHAR(15)  NOT NULL,
        UNIQUE KEY Name_key (Name),
        FOREIGN KEY (ClientID) REFERENCES CLIENT(ClientID)
    ) ENGINE = InnoDB, CHARACTER SET utf8mb4;

CREATE TABLE PUBLICATION_FOR_LOCATOR (
    XLinkID   INTEGER NOT NULL,
    LocatorID INTEGER NOT NULL,
        FOREIGN KEY (XLinkID) REFERENCES XLINK(XLinkID),
        FOREIGN KEY (LocatorID) REFERENCES LOCATOR(LocatorID),
        UNIQUE KEY URI_key (XLinkID,LocatorID)
    ) ENGINE = InnoDB, CHARACTER SET utf8mb4;

CREATE TABLE AUTHENTICATOR (
    AuthenticatorID INTEGER AUTO_INCREMENT PRIMARY KEY,
    MemberID        INTEGER        NOT NULL,
    PublicID        VARCHAR(16)    NOT NULL,
    Type            VARCHAR(20)    NOT NULL,
    Name            VARCHAR(50)    NULL,
    Confidential    VARBINARY(255) NULL,
    Parameters      VARCHAR(100)   NULL,
    CredentialId    VARBINARY(255) NULL,
    PublicKey       BLOB           NULL,
    Verified        TINYINT        NOT NULL,
    SignCount       INTEGER        NULL,
    Created         DATETIME(3)    NOT NULL,
    LastUsed        DATETIME(3)    NULL,
       UNIQUE KEY PublicID_key (PublicID),
       INDEX CredentialId_idx (CredentialId),
       FOREIGN KEY (MemberID) REFERENCES MEMBER(MemberID)
) ENGINE = InnoDB, CHARACTER SET utf8mb4;

CREATE TABLE DATABASE_METADATA(
    Version VARCHAR(20) NULL
    ) ENGINE = InnoDB, CHARACTER SET utf8mb4;

INSERT INTO DATABASE_METADATA VALUES('6.20');

CREATE INDEX ControlGroupName_idx ON DGROUP(ControlGroupName);

CREATE INDEX GroupTitle_idx ON DGROUP(Title);

CREATE INDEX FirstName_idx ON MEMBER(FirstName);

CREATE INDEX Surname_idx ON MEMBER(Surname);

CREATE INDEX Email_idx ON MEMBER(Email);

CREATE INDEX EmailDomain_idx ON MEMBER(EmailDomain);

CREATE INDEX DocID_idx ON URI(DocID);

CREATE INDEX UserTitle_idx ON URI(UserTitle(100));

CREATE INDEX Path_idx ON URI(Path);

CREATE INDEX Path2_idx ON DGROUPURI(Path);

CREATE INDEX ParentPath_idx ON URI(ParentPath);

CREATE INDEX ContentRole_idx ON XLINK(ContentRole);

CREATE INDEX ContentTitle_idx ON XLINK(ContentTitle(100));

CREATE INDEX XLink_Type_idx ON XLINK(Type);

CREATE INDEX XLink_Status_idx ON XLINK(Status);

CREATE INDEX XLink_CreationDate_idx ON XLINK(CreationDate);

CREATE INDEX XLink_AssignedDate_idx ON XLINK(AssignedDate);

CREATE INDEX XLink_DueDate_idx ON XLINK(DueDate);

CREATE INDEX AuthorOnly_idx ON XLINK(AuthorOnly);

CREATE INDEX Accepted_idx ON XLINK(Accepted);

CREATE INDEX LFX_Role_idx ON LOCATOR_FOR_XLINK(Role);