<!--
  This schematron validates PSML file for portable level

  @author Philip Rutherford
  @author Christophe Lauret
  @version 5.9910
-->
<sch:schema xmlns:sch="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2">

  <!-- Sent by PageSeeder based on `maxForwardXRefs` global property -->
  <sch:let name="max-xrefs" value="3000" />

  <sch:ns prefix="ps" uri="http://www.pageseeder.com/editing/2.0"/>

  <!--
    Set of rules applying to the entire document
  -->
  <sch:pattern>

    <!-- Document -->
    <sch:rule context="/document">

      <sch:let name="fragment-ids" value="section/fragment/@id  | section/xref-fragment/@id |
                                          section/properties-fragment/@id | section/media-fragment/@id "/>
      <sch:let name="distinct-fragment-ids" value="distinct-values(for $i in $fragment-ids return lower-case($i))"/>

      <!--
        Portable format cannot contain fragments element
       -->
      <sch:assert test="not(./@level='portable') or not(./fragments)">
        Portable format cannot contain fragments element.
      </sch:assert>

      <!--
        Portable format must have at least one section
       -->
      <sch:assert test="not(./@level='portable') or ./section">
        Portable format must contain at least one section.
      </sch:assert>

      <!--
        Metadata format cannot contain section or toc elements
       -->
      <sch:assert test="not(./@level='metadata') or not(./section or ./toc)">
        Metadata format cannot contain section or toc elements.
      </sch:assert>

      <!-- Maximum number of xrefs -->
      <sch:assert test="count(.//xref | ..//blockxref) &lt;= $max-xrefs">
        For performance reasons, the number of cross-references in a single document is limited to <sch:value-of select="$max-xrefs" />,
        this document contains <sch:value-of select="count(.//xref | .//blockxref)" />.
      </sch:assert>

      <!-- fragment ID 'default' not allowed -->
      <sch:assert test="not($fragment-ids[lower-case(.) = 'default'])">
        Fragment ID 'default' is not allowed in the content.
      </sch:assert>

      <!-- Same fragment ID with different case not allowed -->
      <sch:assert test="count($fragment-ids) = count($distinct-fragment-ids)">
        Same fragment ID with different case not allowed.
      </sch:assert>

    </sch:rule>

    <!-- Document Info -->
    <sch:rule context="/document/documentinfo">

      <!-- Validate title -->
      <sch:assert test="string-length(uri/@title) &lt; 251">
        The document title cannot be more than 250 characters.
      </sch:assert>

      <!-- Validate document id -->
      <sch:assert test="string-length(uri/@docid) &lt; 101">
        The docid cannot be more than 100 characters.
      </sch:assert>

      <!-- Validate labels -->
      <sch:assert test="string-length(uri/labels) &lt; 251">
        The labels cannot be more than 250 characters.
      </sch:assert>

      <!-- Validate publication id -->
      <sch:assert test="string-length(publication/@id) &lt; 251">
        The publication ID cannot be more than 250 characters.
      </sch:assert>

      <!-- Validate publication type -->
      <sch:assert test="string-length(publication/@type) &lt; 51">
        The publication type cannot be more than 50 characters.
      </sch:assert>
    </sch:rule>

    <!-- Properties -->
    <sch:rule context="property[not(ancestor::media-fragment)]">

      <!--
        Single value
       -->
      <sch:assert test="not(@value and value)">
        The property element "<sch:value-of select="@name" />"
        can only have a @value attribute or value elements (not both).
      </sch:assert>

      <!--
        Normal property can only have value attribute or value elements
       -->
      <sch:assert test="not(not(@datatype='xref') and not(@datatype='markdown') and not(@datatype='markup') and
                        (xref or markdown or heading or para or list or nlist or preformat))">
        The property element "<sch:value-of select="@name" />"
        can not have xref, markdown, heading, para, list, nlist or preformat elements
        (use value attribute or value elements).
      </sch:assert>

      <!--
        XRef property can only have xref elements
       -->
      <sch:assert test="not(@datatype='xref' and
                        (@value or value or markdown or heading or para or list or nlist or preformat))">
        The property element "<sch:value-of select="@name" />"
        can not have a @value attribute or markdown, value, heading, para, list, nlist or preformat elements
        (use xref element or leave empty).
      </sch:assert>

      <!--
        Markdown property can only have a markdown element
       -->
      <sch:assert test="not(@datatype='markdown' and
                        (@value or @multiple or value or xref or heading or para or list or nlist or preformat))">
        The property element "<sch:value-of select="@name" />"
        can not have @value or @multiple attributes or xref, value, heading, para, list, nlist or preformat elements
        (use markdown element or leave empty).
      </sch:assert>

      <!--
        Markup property can only have heading, para, list, nlist or preformat elements
       -->
      <sch:assert test="not(@datatype='markup' and
                        (@value or @multiple or value or xref or markdown))">
        The property element "<sch:value-of select="@name" />"
        can not have @value or @multiple attributes or value, xref or markdown elements
        (use heading, para, list, nlist or preformat elements or leave empty).
      </sch:assert>

      <!--
        Markup property can not contain image, xref, placeholder, @indent, @prefix or @numbered
       -->
      <sch:assert test="not(@datatype='markup' and (
        .//image or .//xref or .//placeholder or .//heading[@prefix or @numbered] or .//para[@indent or @prefix or @numbered]))">
        The property element "<sch:value-of select="@name" />"
        can not contain image, xref, placeholder elements or elements with @indent, @prefix or @numbered attributes.
      </sch:assert>

    </sch:rule>


    <!-- Tables -->
    <sch:rule context="table[not(ancestor::media-fragment)]">

      <!-- Nested tables are not allowed -->
      <sch:assert test="not(ancestor::table)">Nested tables are not allowed.</sch:assert>

      <!-- The <col> elements must match the number of columns in the table -->
      <sch:assert test="not(col) or count(col[not(@span)]) + sum(col/@span) = count(row[1]/*[not(@colspan)]) + sum(row[1]/*/@colspan)">
        The &lt;col&gt; elements must match the number of columns in the table.
      </sch:assert>

    </sch:rule>


    <!-- Headings -->
    <sch:rule context="heading[not(ancestor::media-fragment)]">

      <!-- Headings in tables are not allowed -->
      <sch:assert test="not(ancestor::table)">Headings are not allowed inside tables.</sch:assert>

      <!-- Heading cannot not have both 'prefix' and numbered="true" attributes -->
      <sch:assert test="not(@prefix and @numbered='true')">Heading cannot have both 'prefix' and numbered="true" attributes.</sch:assert>

    </sch:rule>

    <!-- Images -->
    <sch:rule context="image[not(ancestor::media-fragment)]">

      <!-- src cannot start with http:// or https:// -->
      <sch:assert test="not(starts-with(@src,'http://') or starts-with(@src,'https://'))">Image src cannot start with http:// or https://.</sch:assert>

      <!-- One of src, uriid or docid is required -->
      <sch:assert test="@uriid or @docid or @src">One of src, uriid or docid is required on image element.</sch:assert>

    </sch:rule>

    <!-- Paras -->
    <sch:rule context="para[not(ancestor::media-fragment)]">

      <!-- Para cannot have both 'prefix' and numbered="true" attributes -->
      <sch:assert test="not(@prefix and @numbered='true')">Para cannot have both 'prefix' and numbered="true" attributes.</sch:assert>

    </sch:rule>

    <!-- XRefs -->
    <sch:rule context="xref[not(ancestor::media-fragment)]|blockxref[not(ancestor::media-fragment)]">

      <!-- XRefs must have a 'frag' attribute -->
      <sch:assert test="@frag">XRefs must have a 'frag' attribute (it can be lost when copy/pasting HTML instead of the source).</sch:assert>

    </sch:rule>

    <!-- Links -->
    <sch:rule context="link[not(ancestor::media-fragment)]">

      <!-- Link must not contain 'image', 'link' or 'xref' elements -->
      <sch:assert test="not(.//image|.//link|.//xref)">
        Link must not contain 'image', 'link' or 'xref' elements.
      </sch:assert>

    </sch:rule>


  </sch:pattern>

</sch:schema>
