<?xml version="1.0"?>
<!--
  This schematron defines the rules used for the template namespace in a PSML media template configuration file.

  @version 5.8200
-->
<sch:schema xmlns:sch="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2">

  <!-- define namespace -->
  <sch:ns uri="http://pageseeder.com/psml/template" prefix="t" />

  <sch:title>Document template namespace validation</sch:title>

  <!--
    Set of rules applying to the template elements
  -->
  <sch:pattern>
    <sch:title>Elements</sch:title>

    <sch:rule context="document">

      <!-- Attribute 'level' on element 'document' must equal 'metadata'  -->
      <sch:assert test="@level='metadata'">Attribute 'level' on element 'document' must equal 'metadata'.</sch:assert>

    </sch:rule>

    <sch:rule context="t:param">

      <!-- Attribute name is required -->
      <sch:assert test="@name">Missing required attribute 'name' on element 't:param'.</sch:assert>

      <!-- Only attributes are name, default and type -->
      <sch:assert test="empty(@*[name() != 'name'][name() != 'title'][name() != 'default'][name() != 'type'])">Invalid attribute '<sch:value-of
        select="@*[name() != 'name'][name() != 'title'][name() != 'default'][name() != 'type']/name()"
        />' on t:param element, only 'name', 'title', 'default' and 'type' are allowed.</sch:assert>

      <!-- no children allowed -->
      <sch:assert test="empty(*)">No children elements allowed in element 't:param'.</sch:assert>

    </sch:rule>

    <sch:rule context="t:value">

      <!-- Attribute name is required -->
      <sch:assert test="@name">Missing required attribute 'name' on element 't:value'.</sch:assert>

      <!-- Only attribute is name -->
      <sch:assert test="empty(@*[name() != 'name'])">Invalid attribute '<sch:value-of select="@*[name() != 'name']/name()"
        />' on t:value element, only 'name' is allowed.</sch:assert>

      <!-- no children allowed -->
      <sch:assert test="empty(*)">No children elements allowed in element 't:value'.</sch:assert>

    </sch:rule>

    <sch:rule context="t:fragment">

      <!-- Attribute type is required -->
      <sch:assert test="@type">Missing required attribute 'type' on element 't:fragment'.</sch:assert>

      <!-- Attribute title is required -->
      <sch:assert test="@title">Missing required attribute 'title' on element 't:fragment'.</sch:assert>

      <!-- Only attribute is type -->
      <sch:assert test="empty(@*[name() != 'type'][name() != 'title'])">Invalid attribute '<sch:value-of select="@*[name() != 'type'][name() != 'title']/name()"
        />' on t:fragment element, only 'type' and 'title' are allowed.</sch:assert>

      <!-- only fragment children allowed -->
      <sch:assert test="*[contains(name(), 'fragment')]">Only fragment elements are allowed as children of element 't:fragment'.</sch:assert>

    </sch:rule>

    <sch:rule context="t:fragment-ref">

      <!-- Attribute id is required -->
      <sch:assert test="@id">Missing required attribute 'id' on element 't:fragment-ref'.</sch:assert>

      <!-- Attribute type is required -->
      <sch:assert test="@type">Missing required attribute 'type' on element 't:fragment-ref'.</sch:assert>

      <!-- Only attributes are id and type -->
      <sch:assert test="empty(@*[name() != 'id'][name() != 'type'])">Invalid attribute '<sch:value-of
        select="@*[name() != 'id'][name() != 'type']/name()"
        />' on 't:fragment-ref' element, only 'id' and 'type' are allowed.</sch:assert>

      <!-- Attribute type must match a defined type -->
      <sch:assert test="//t:fragment[@type = current()/@type]">Invalid 'type' attribute value on element
        't:fragment-ref', no fragment found with type '<sch:value-of select="@type" />'.</sch:assert>

      <!-- no children allowed -->
      <sch:assert test="empty(*)">No children elements allowed in element 't:fragment-ref'.</sch:assert>

    </sch:rule>

   <sch:rule context="t:*">
   
     <!-- Elements starting with t: must be one of t:param, t:value, t:fragment, t:fragment-ref -->
     <sch:assert test="local-name(.)='param' or local-name(.)='value' or
         local-name(.)='fragment' or local-name(.)='fragment-ref'">Invalid element 't:<sch:value-of
       select="local-name(.)" />' only 't:param', 't:value', 't:fragment' and 't:fragment-ref' are allowed.</sch:assert>
       
   </sch:rule>
   
  </sch:pattern>

</sch:schema>