<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                exclude-result-prefixes="#all">

  <!--
  match: Defines the nodes to which the key will be applied
  use: The value of the key for each of the nodes
  self: The current node (abbreviated ".")
  attribute: Attributes of the current node (abbreviated "@")
   -->
  <xsl:key name="document" match="//document/@uriid" use="." />
  <xsl:param name="version"  select="'full'"/>

  <xsl:template match="/">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="report">
    <report>
      <xsl:apply-templates/>
      <xsl:call-template name="document-report"/>
    </report>
  </xsl:template>

  <xsl:template match="elements">
    <xsl:if test="$version='element' or $version='full'">
      <xsl:call-template name="generic-table" />
    </xsl:if>
  </xsl:template>

  <xsl:template match="attributes">
    <xsl:if test="$version='attribute' or $version='full'">
      <xsl:call-template name="generic-table" />
    </xsl:if>
  </xsl:template>

  <xsl:template match="parents-children">
    <xsl:if test="$version='parent-children' or $version='full'">
      <xsl:call-template name="generic-table" />
    </xsl:if>
  </xsl:template>

  <xsl:template match="xpaths">
    <xsl:if test="$version='xpath' or $version='full'">
      <xsl:call-template name="generic-table" />
    </xsl:if>
  </xsl:template>

  <xsl:template match="labels">
    <xsl:if test="$version='label' or $version='full'">
      <xsl:call-template name="generic-table" />
    </xsl:if>
  </xsl:template>

  <xsl:template match="attributes-value">
    <xsl:if test="$version='attribute-value' or $version='full'">
      <xsl:call-template name="generic-table" />
    </xsl:if>
  </xsl:template>

  <xsl:template match="images">
    <xsl:if test="$version='image' or $version='full'">
      <xsl:call-template name="generic-table" />
    </xsl:if>
  </xsl:template>

  <xsl:template match="links">
    <xsl:if test="$version='link' or $version='full'">
      <xsl:call-template name="generic-table" />
    </xsl:if>
  </xsl:template>

  <xsl:template match="linkeds">
    <xsl:if test="$version='linked' or $version='full'">
      <xsl:call-template name="generic-table" />
    </xsl:if>
  </xsl:template>

<!-- Generic Table -->
  <xsl:template name="generic-table">
    <xsl:copy>
      <xsl:copy-of select="node()"/>
    </xsl:copy>
  </xsl:template>

  <xsl:template name="document-report" >
    <xsl:if test="$version='document' or $version='full'">
      <documents>
      <!-- It doesn't work if the parser is not saxon. -->
      <xsl:for-each select="//document[@uriid[generate-id() = generate-id(key('document',.)[1])]]">
        <xsl:variable name="current-uriid" select="@uriid"/>
        <document uriid="{$current-uriid}">
          <xsl:variable name="number-of-element-occurrences" select="sum(//document[@uriid = $current-uriid][parent::element]/@occurrence)"/>
          <xsl:attribute name="element-occurrence" select="$number-of-element-occurrences"/>
          <xsl:variable name="number-of-attribute-occurrences" select="sum(//document[@uriid = $current-uriid][parent::attribute]/@occurrence)"/>
          <xsl:attribute name="attribute-occurrence" select="$number-of-attribute-occurrences"/>
          <xsl:variable name="number-of-path-with-content-occurrence" select="sum(//document[@uriid = $current-uriid][parent::xpath[@has-content='Y']]/@occurrence)"/>
          <xsl:attribute name="xpath-with-content-occurrence" select="$number-of-path-with-content-occurrence"/>
          <xsl:variable name="number-of-label-number" select="count(//label[document[@uriid = $current-uriid][@occurrence &gt; 0]])"/>
          <xsl:attribute name="label-number" select="$number-of-label-number"/>
          <xsl:variable name="number-of-label-occurrences" select="sum(//document[@uriid = $current-uriid][parent::label]/@occurrence)"/>
          <xsl:attribute name="label-occurrence" select="$number-of-label-occurrences"/>
          <xsl:variable name="number-of-attribute-value-occurrences" select="sum(//document[@uriid = $current-uriid][parent::attribute-value]/@occurrence)"/>
          <xsl:attribute name="attribute-value-occurrence" select="$number-of-attribute-value-occurrences"/>
          <xsl:variable name="number-total-occurrences" select="$number-of-element-occurrences + $number-of-attribute-occurrences + $number-of-label-occurrences + $number-of-path-with-content-occurrence"/>
          <xsl:attribute name="total-occurrence" select="$number-total-occurrences"/>
        </document>
      </xsl:for-each>
      </documents>
    </xsl:if>
  </xsl:template>

</xsl:stylesheet>