<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                exclude-result-prefixes="#all">
  <!-- <xsl:output method="text" encoding="UTF-8" byte-order-mark="yes"/> -->
  <xsl:output method="text"/>
  <xsl:key name="document" match="//document/@uriid" use="." />
  <xsl:param name="version"  select="'full'"/>

  <xsl:variable name="delimiter" select="','" />
  <xsl:variable name="label-nb-found" select="'Nb Found'" />
  <xsl:variable name="label-unique-uriids" select="'Unique URIIDs'" />
  <xsl:variable name="label-uri" select="'URI IDs(Occurrence)'" />
  <xsl:variable name="label-has-content" select="'Has content'" />
  <xsl:variable name="label-extra" select="'Extra'" />
  <xsl:variable name="label-nesting" select="'Nesting'" />

  <xsl:template match="/">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="report">
    <!-- Summary -->
    <xsl:call-template name="summary"/>

    <!-- Each part -->
    <xsl:apply-templates/>

    <!-- Overview by document -->
    <xsl:call-template name="document-report"/>
  </xsl:template>

  <xsl:template match="elements">
    <xsl:if test="$version='element' or $version='full'">
      <xsl:call-template name="generic-table" />
    </xsl:if>
  </xsl:template>

  <xsl:template match="attributes">
    <xsl:if test="$version='attribute' or $version='full'">
      <xsl:call-template name="generic-table" />
    </xsl:if>
  </xsl:template>

  <xsl:template match="parents-children">
    <xsl:if test="$version='parent-children' or $version='full'">
      <xsl:call-template name="generic-table" />
    </xsl:if>
  </xsl:template>

  <xsl:template match="xpaths">
    <xsl:if test="$version='xpath' or $version='full'">
      <xsl:call-template name="generic-table" />
    </xsl:if>
  </xsl:template>

  <xsl:template match="labels">
    <xsl:if test="$version='label' or $version='full'">
      <xsl:call-template name="generic-table" />
    </xsl:if>
  </xsl:template>

  <xsl:template match="attributes-value">
    <xsl:if test="$version='attribute-value' or $version='full'">
      <xsl:call-template name="attribute-value-table" />
    </xsl:if>
  </xsl:template>

  <xsl:template match="images">
    <xsl:if test="$version='image' or $version='full'">
      <xsl:call-template name="image-table" />
    </xsl:if>
  </xsl:template>

  <xsl:template match="links">
    <xsl:if test="$version='link' or $version='full'">
      <xsl:call-template name="unformat-table" >
        <xsl:with-param name="title" select="'Links Table'"/>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>

  <xsl:template match="linkeds">
    <xsl:if test="$version='linked' or $version='full'">
      <xsl:call-template name="unformat-table" >
        <xsl:with-param name="title" select="'Linked By Table'"/>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>



  <!-- Generic Table -->
  <xsl:template name="generic-table">

    <!-- Table Header -->
    <xsl:choose>
      <xsl:when test="name(.) = 'elements'">
        <xsl:text>Elements Report</xsl:text>
      </xsl:when>
      <xsl:when test="name(.) = 'attributes'">
        <xsl:text>Attributes Report</xsl:text>
      </xsl:when>
      <xsl:when test="name(.) = 'parents-children'">
        <xsl:text>Parents/Children Report</xsl:text>
      </xsl:when>
      <xsl:when test="name(.) = 'xpaths'">
        <xsl:text>XPaths Report</xsl:text>
      </xsl:when>
      <xsl:when test="name(.) = 'labels'">
        <xsl:text>Labels Report</xsl:text>
      </xsl:when>
    </xsl:choose>
    <xsl:text>&#10;</xsl:text>

    <!-- Columns Header -->
    <xsl:choose>
      <xsl:when test="name(.) = 'elements'">
        <xsl:text>Element</xsl:text>
      </xsl:when>
      <xsl:when test="name(.) = 'attributes'">
        <xsl:text>Attribute</xsl:text>
      </xsl:when>
      <xsl:when test="name(.) = 'parents-children'">
        <xsl:text>Parent/Children</xsl:text>
      </xsl:when>
      <xsl:when test="name(.) = 'xpaths'">
        <xsl:text>XPaths</xsl:text>
      </xsl:when>
      <xsl:when test="name(.) = 'labels'">
        <xsl:text>Type</xsl:text>
        <xsl:value-of select="$delimiter" />
        <xsl:text>Name</xsl:text>
        <xsl:value-of select="$delimiter" />
        <xsl:value-of select="$label-nesting"/>
      </xsl:when>
    </xsl:choose>
    <xsl:value-of select="$delimiter" />
    <xsl:value-of select="$label-nb-found" />
    <xsl:value-of select="$delimiter" />
    <xsl:value-of select="$label-unique-uriids" />
    <xsl:value-of select="$delimiter" />
    <xsl:value-of select="$label-uri" />
    <xsl:if test="name(.) = 'xpaths'">
      <xsl:value-of select="$delimiter" />
      <xsl:value-of select="$label-has-content"/>
      <xsl:value-of select="$delimiter" />
      <xsl:value-of select="$label-extra"/>
    </xsl:if>
    <xsl:text>&#10;</xsl:text>

    <!-- Table Lines -->
    <xsl:for-each select="element | attribute | parent-children | xpath | label">

      <xsl:if test="@type">
        <xsl:value-of select="@type"/>
        <xsl:value-of select="$delimiter" />
      </xsl:if>
      <xsl:value-of select="@name"/>
      <xsl:value-of select="$delimiter" />
      <xsl:if test="@nesting">
        <xsl:value-of select="@nesting"/>
        <xsl:value-of select="$delimiter" />
      </xsl:if>
      <xsl:value-of select="@found"/>
      <xsl:value-of select="$delimiter" />
      <xsl:value-of select="@unique-uriids"/>
      <xsl:value-of select="$delimiter" />
      <xsl:text>"</xsl:text>
      <xsl:apply-templates select="document"/>
      <xsl:text>"</xsl:text>
      <xsl:if test="@has-content">
        <xsl:value-of select="$delimiter" />
        <xsl:value-of select="@has-content"/>
      </xsl:if>
      <xsl:if test="@extra">
        <xsl:value-of select="$delimiter" />
        <xsl:value-of select="@extra"/>
      </xsl:if>
      <xsl:text>&#10;</xsl:text>
    </xsl:for-each>
    <xsl:text>&#10;</xsl:text>
  </xsl:template>


  <!-- Attribute Value Table -->
  <xsl:template name="attribute-value-table">

    <!-- Table Header -->
    <xsl:text>Attributes Value Report</xsl:text>
    <xsl:text>&#10;</xsl:text>

    <!-- Columns Header -->
    <xsl:text>Element</xsl:text>
    <xsl:value-of select="$delimiter" />
    <xsl:text>Attribute</xsl:text>
    <xsl:value-of select="$delimiter" />
    <xsl:text>Value</xsl:text>
    <xsl:value-of select="$delimiter" />
    <xsl:text>Found</xsl:text>
    <xsl:value-of select="$delimiter" />
    <xsl:text>Unique URIIDS</xsl:text>
    <xsl:value-of select="$delimiter" />
    <xsl:value-of select="$label-uri" />
    <xsl:text>&#10;</xsl:text>

    <!-- Table Lines -->
    <xsl:for-each select="attribute-value">

      <xsl:value-of select="@element"/>
      <xsl:value-of select="$delimiter" />
      <xsl:value-of select="@name"/>
      <xsl:value-of select="$delimiter" />
      <xsl:value-of select="@value"/>
      <xsl:value-of select="$delimiter" />
      <xsl:value-of select="@found"/>
      <xsl:value-of select="$delimiter" />
      <xsl:value-of select="@unique-uriids"/>
      <xsl:value-of select="$delimiter" />
      <xsl:text>"</xsl:text>
      <xsl:apply-templates select="document"/>
      <xsl:text>"</xsl:text>
      <xsl:text>&#10;</xsl:text>
    </xsl:for-each>
    <xsl:text>&#10;</xsl:text>
  </xsl:template>


  <!-- Image Table -->
  <xsl:template name="image-table">

    <!-- Table Header -->
    <xsl:text>Image Report</xsl:text>
    <xsl:text>&#10;</xsl:text>

    <!-- Columns Header -->
    <xsl:text>Src</xsl:text>
    <xsl:value-of select="$delimiter" />
    <xsl:text>Alt</xsl:text>
    <xsl:value-of select="$delimiter" />
    <xsl:text>PS Height</xsl:text>
    <xsl:value-of select="$delimiter" />
    <xsl:text>PS Width</xsl:text>
    <xsl:value-of select="$delimiter" />
    <xsl:text>IMG Height</xsl:text>
    <xsl:value-of select="$delimiter" />
    <xsl:text>IMG Width</xsl:text>
    <xsl:value-of select="$delimiter" />
    <xsl:text>IMG Path</xsl:text>
    <xsl:value-of select="$delimiter" />
    <xsl:text>Document</xsl:text>
    <xsl:value-of select="$delimiter" />
    <xsl:text>Dif</xsl:text>
    <xsl:text>&#10;</xsl:text>

    <!-- Table Lines -->
    <xsl:for-each select="image">
      <xsl:for-each select="@*">
        <!-- <xsl:value-of select="name()"/> -->
        <!-- <xsl:value-of select="$delimiter" /> -->
        <xsl:value-of select="."/>
        <xsl:value-of select="$delimiter" />
      </xsl:for-each>

      <xsl:text>&#10;</xsl:text>
    </xsl:for-each>
    <xsl:text>&#10;</xsl:text>
  </xsl:template>

   <!-- Unformat Table -->
  <xsl:template name="unformat-table">
    <xsl:param name = "title" />
    <!-- Table Header -->
    <xsl:value-of select ="$title"/>
    <xsl:text>&#10;</xsl:text>

    <!-- Table Lines -->
    <xsl:for-each select="child::*">
      <!--  Headers -->
      <xsl:if test="position() = 1">
        <xsl:for-each select="@*">
          <xsl:value-of select="name(.)"/>
          <xsl:value-of select="$delimiter" />
        </xsl:for-each>
        <xsl:text>&#10;</xsl:text>
      </xsl:if>

      <!-- Values -->
      <xsl:for-each select="@*">
        <xsl:value-of select="."/>
        <xsl:value-of select="$delimiter" />
      </xsl:for-each>
      <xsl:text>&#10;</xsl:text>
    </xsl:for-each>
    <xsl:text>&#10;</xsl:text>
  </xsl:template>


  <!-- Generic Document Template -->
  <xsl:template match="document">
      <xsl:value-of select="@uriid"/>
      <xsl:text>(</xsl:text>
      <xsl:value-of select="@occurrence"/>
      <xsl:text>)</xsl:text>
      <xsl:if test="following-sibling::document">
        <xsl:value-of select="$delimiter" />
      </xsl:if>
  </xsl:template>


  <!-- Report By Document -->

  <xsl:template name="document-report">

    <xsl:if test="$version='document' or $version='full'">

      <!-- Document Report Header -->
      <xsl:text>Documents Report</xsl:text>
      <xsl:text>&#10;</xsl:text>

      <!-- Document Report Columns Header -->
      <xsl:text>URI-IDS</xsl:text>
      <xsl:value-of select="$delimiter" />
      <xsl:text>Elements</xsl:text>
      <xsl:value-of select="$delimiter" />
      <xsl:text>Attributes</xsl:text>
      <xsl:value-of select="$delimiter" />
      <xsl:text>XPaths(With Content)</xsl:text>
      <xsl:value-of select="$delimiter" />
      <xsl:text>Labels(Quantity)</xsl:text>
      <xsl:value-of select="$delimiter" />
      <xsl:text>Labels(Occurrence)</xsl:text>
      <xsl:value-of select="$delimiter" />
      <xsl:text>Attributes Value(Occurrence)</xsl:text>
      <xsl:value-of select="$delimiter" />
      <xsl:text>Total Occurrence</xsl:text>
      <xsl:text>&#10;</xsl:text>

      <!-- It doesn't work if the parser is not saxon. -->
      <xsl:for-each select="//document[@uriid[generate-id(.) = generate-id(key('document',.)[1])]]">
        <xsl:variable name="current-uriid" select="@uriid"/>
        <xsl:value-of select="$current-uriid"/>
        <xsl:value-of select="$delimiter" />
        <xsl:variable name="number-of-element-occurrences" select="sum(//document[@uriid = $current-uriid][parent::element]/@occurrence)"/>
        <xsl:value-of select="$number-of-element-occurrences"/>
        <xsl:value-of select="$delimiter" />
        <xsl:variable name="number-of-attribute-occurrences" select="sum(//document[@uriid = $current-uriid][parent::attribute]/@occurrence)"/>
        <xsl:value-of select="$number-of-attribute-occurrences"/>
        <xsl:value-of select="$delimiter" />
        <xsl:variable name="number-of-path-with-content-occurrence" select="sum(//document[@uriid = $current-uriid][parent::xpath[@has-content='Y']]/@occurrence)"/>
        <xsl:value-of select="$number-of-path-with-content-occurrence"/>
        <xsl:value-of select="$delimiter" />
        <xsl:variable name="number-of-label-number" select="count(//label[document[@uriid = $current-uriid][@occurrence &gt; 0]])"/>
        <xsl:value-of select="$number-of-label-number"/>
        <xsl:value-of select="$delimiter" />
        <xsl:variable name="number-of-label-occurrences" select="sum(//document[@uriid = $current-uriid][parent::label]/@occurrence)"/>
        <xsl:value-of select="$number-of-label-occurrences"/>
        <xsl:value-of select="$delimiter" />
        <xsl:variable name="number-of-attribute-value-occurrences" select="sum(//document[@uriid = $current-uriid][parent::attribute-value]/@occurrence)"/>
        <xsl:value-of select="$number-of-attribute-value-occurrences"/>
        <xsl:value-of select="$delimiter" />
        <xsl:variable name="number-total-occurrences" select="$number-of-element-occurrences + $number-of-attribute-occurrences + $number-of-label-occurrences + $number-of-path-with-content-occurrence"/>
        <xsl:value-of select="$number-total-occurrences"/>
        <xsl:text>&#10;</xsl:text>
      </xsl:for-each>
      <xsl:text>&#10;</xsl:text>
    </xsl:if>
  </xsl:template>

  <xsl:template name="summary">
    <xsl:value-of select="@title"/>
    <xsl:text>&#10;</xsl:text>
    <xsl:text>&#10;</xsl:text>
    <xsl:text>Files Parsed</xsl:text>
    <xsl:value-of select="$delimiter" />
    <xsl:text>Elementes Found</xsl:text>
    <xsl:value-of select="$delimiter" />
    <xsl:text>Source</xsl:text>
    <xsl:text>&#10;</xsl:text>
    <xsl:value-of select="@files-parsed"/>
    <xsl:value-of select="$delimiter" />
    <xsl:value-of select="@elements-found"/>
    <xsl:value-of select="$delimiter" />
    <xsl:text>&#10;</xsl:text>
    <xsl:text>&#10;</xsl:text>
  </xsl:template>
</xsl:stylesheet>