/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.method;

import java.util.Collection;
import java.util.List;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.expression.BooleanLiteral;
import org.datanucleus.store.rdbms.sql.expression.CollectionExpression;
import org.datanucleus.store.rdbms.sql.expression.CollectionLiteral;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpressionFactory;
import org.datanucleus.store.rdbms.sql.method.SQLMethod;
import org.datanucleus.util.Localiser;

public class CollectionIsEmptyMethod
implements SQLMethod {
    @Override
    public SQLExpression getExpression(SQLStatement stmt, SQLExpression expr, List<SQLExpression> args) {
        Class elementType;
        if (args != null && args.size() > 0) {
            throw new NucleusException(Localiser.msg((String)"060015", (Object[])new Object[]{"isEmpty", "CollectionExpression"}));
        }
        SQLExpressionFactory exprFactory = stmt.getSQLExpressionFactory();
        if (expr instanceof CollectionLiteral) {
            Collection coll = (Collection)((CollectionLiteral)expr).getValue();
            boolean isEmpty = coll == null || coll.size() == 0;
            JavaTypeMapping m = exprFactory.getMappingForType(Boolean.TYPE, false);
            return new BooleanLiteral(stmt, m, isEmpty ? Boolean.TRUE : Boolean.FALSE);
        }
        AbstractMemberMetaData mmd = ((CollectionExpression)expr).getJavaTypeMapping().getMemberMetaData();
        if (mmd.isSerialized()) {
            throw new NucleusUserException("Cannot perform Collection.isEmpty when the collection is being serialised");
        }
        ClassLoaderResolver clr = stmt.getQueryGenerator().getClassLoaderResolver();
        ApiAdapter api = stmt.getRDBMSManager().getApiAdapter();
        if (!api.isPersistable(elementType = clr.classForName(mmd.getCollection().getElementType())) && mmd.getJoinMetaData() == null) {
            throw new NucleusUserException("Cannot perform Collection.isEmpty when the collection<Non-Persistable> is not in a join table");
        }
        SQLExpression sizeExpr = exprFactory.invokeMethod(stmt, Collection.class.getName(), "size", expr, args);
        JavaTypeMapping mapping = exprFactory.getMappingForType(Integer.class, true);
        SQLExpression zeroExpr = exprFactory.newLiteral(stmt, mapping, 0);
        return sizeExpr.eq(zeroExpr);
    }
}

