/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms;

import java.sql.Connection;
import java.sql.SQLException;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.transaction.TransactionUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public abstract class AbstractSchemaTransaction {
    protected final RDBMSStoreManager rdbmsMgr;
    protected final int isolationLevel;
    protected final int maxRetries;
    protected ManagedConnection mconn;
    private Connection conn;

    public AbstractSchemaTransaction(RDBMSStoreManager rdbmsMgr, int isolationLevel) {
        this.rdbmsMgr = rdbmsMgr;
        this.isolationLevel = isolationLevel;
        this.maxRetries = rdbmsMgr.getIntProperty("datanucleus.rdbms.classAdditionMaxRetries");
    }

    public abstract String toString();

    protected abstract void run(ClassLoaderResolver var1) throws SQLException;

    protected Connection getCurrentConnection() throws SQLException {
        if (this.conn == null) {
            this.mconn = this.rdbmsMgr.getConnectionManager().getConnection(this.isolationLevel);
            this.conn = (Connection)this.mconn.getConnection();
            if (NucleusLogger.DATASTORE_SCHEMA.isDebugEnabled()) {
                NucleusLogger.DATASTORE_SCHEMA.debug((Object)Localiser.msg((String)"050057", (Object[])new Object[]{StringUtils.toJVMIDString((Object)this.conn), TransactionUtils.getNameForTransactionIsolationLevel((int)this.isolationLevel)}));
            }
        }
        return this.conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void execute(ClassLoaderResolver clr) {
        int attempts = 0;
        while (true) {
            try {
                try {
                    boolean succeeded = false;
                    try {
                        this.run(clr);
                        succeeded = true;
                    }
                    catch (Throwable throwable) {
                        if (this.conn == null || this.isolationLevel == 0 || this.conn.getAutoCommit()) throw throwable;
                        if (succeeded) {
                            if (NucleusLogger.DATASTORE_SCHEMA.isDebugEnabled()) {
                                NucleusLogger.DATASTORE_SCHEMA.debug((Object)Localiser.msg((String)"050053", (Object[])new Object[]{StringUtils.toJVMIDString((Object)this.conn)}));
                            }
                            this.conn.commit();
                            throw throwable;
                        } else {
                            if (NucleusLogger.DATASTORE_SCHEMA.isDebugEnabled()) {
                                NucleusLogger.DATASTORE_SCHEMA.debug((Object)Localiser.msg((String)"050054", (Object[])new Object[]{StringUtils.toJVMIDString((Object)this.conn)}));
                            }
                            this.conn.rollback();
                        }
                        throw throwable;
                    }
                    if (this.conn != null && this.isolationLevel != 0 && !this.conn.getAutoCommit()) {
                        if (succeeded) {
                            if (NucleusLogger.DATASTORE_SCHEMA.isDebugEnabled()) {
                                NucleusLogger.DATASTORE_SCHEMA.debug((Object)Localiser.msg((String)"050053", (Object[])new Object[]{StringUtils.toJVMIDString((Object)this.conn)}));
                            }
                            this.conn.commit();
                        } else {
                            if (NucleusLogger.DATASTORE_SCHEMA.isDebugEnabled()) {
                                NucleusLogger.DATASTORE_SCHEMA.debug((Object)Localiser.msg((String)"050054", (Object[])new Object[]{StringUtils.toJVMIDString((Object)this.conn)}));
                            }
                            this.conn.rollback();
                        }
                    }
                    if (this.conn == null) return;
                }
                catch (Throwable throwable) {
                    if (this.conn == null) throw throwable;
                    if (NucleusLogger.DATASTORE_SCHEMA.isDebugEnabled()) {
                        NucleusLogger.DATASTORE_SCHEMA.debug((Object)Localiser.msg((String)"050055", (Object[])new Object[]{StringUtils.toJVMIDString((Object)this.conn)}));
                    }
                    this.mconn.release();
                    this.conn = null;
                    throw throwable;
                }
                if (NucleusLogger.DATASTORE_SCHEMA.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_SCHEMA.debug((Object)Localiser.msg((String)"050055", (Object[])new Object[]{StringUtils.toJVMIDString((Object)this.conn)}));
                }
                this.mconn.release();
                this.conn = null;
                return;
            }
            catch (SQLException e) {
                if (++attempts < this.maxRetries) continue;
                throw new NucleusDataStoreException(Localiser.msg((String)"050056", (Object[])new Object[]{this}), (Throwable)e);
            }
            break;
        }
    }
}

