/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.xml;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.berlioz.BerliozException;
import org.pageseeder.berlioz.xml.BerliozEntityResolver;
import org.pageseeder.berlioz.xml.BerliozErrorHandler;
import org.pageseeder.berlioz.xml.XMLUtils;
import org.pageseeder.xmlwriter.XML;
import org.pageseeder.xmlwriter.XMLStringWriter;
import org.pageseeder.xmlwriter.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public final class XMLCopy
extends DefaultHandler
implements ContentHandler,
LexicalHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(XMLCopy.class);
    private static final String LEXICAL_HANDLER_PROPERTY = "http://xml.org/sax/properties/lexical-handler";
    private static volatile boolean supportsComments = true;
    private final XMLWriter to;
    private final Map<String, String> mapping = new HashMap<String, String>();

    public XMLCopy(XMLWriter xml) {
        this.to = xml;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        try {
            this.to.openElement(qName);
            for (int i = 0; i < atts.getLength(); ++i) {
                String name = atts.getQName(i);
                String value = atts.getValue(i);
                if (name == null || value == null) continue;
                this.to.attribute(name, value);
            }
            if (!this.mapping.isEmpty()) {
                for (Map.Entry<String, String> e : this.mapping.entrySet()) {
                    boolean hasPrefix = e.getKey() != null && e.getKey().length() > 0;
                    this.to.attribute("xmlns" + (hasPrefix ? ":" + e.getKey() : e.getKey()), e.getValue());
                }
                this.mapping.clear();
            }
        }
        catch (IOException ex) {
            throw new SAXException(ex);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            this.to.writeText(ch, start, length);
        }
        catch (IOException ex) {
            throw new SAXException(ex);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            this.to.closeElement();
        }
        catch (IOException ex) {
            throw new SAXException(ex);
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
        boolean hasPrefix = prefix != null && prefix.length() > 0;
        this.mapping.put(hasPrefix ? prefix : "", uri);
    }

    @Override
    public void processingInstruction(String target, @Nullable String data) throws SAXException {
        try {
            this.to.writePI(target, data);
        }
        catch (IOException ex) {
            throw new SAXException(ex);
        }
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        try {
            this.to.writeComment(String.copyValueOf(ch, start, length));
        }
        catch (IOException ex) {
            throw new SAXException(ex);
        }
    }

    @Override
    public void startCDATA() {
    }

    @Override
    public void endCDATA() {
    }

    @Override
    public void startDTD(String name, @Nullable String publicId, @Nullable String systemId) {
    }

    @Override
    public void endDTD() {
    }

    @Override
    public void startEntity(String name) {
    }

    @Override
    public void endEntity(String name) {
    }

    public static boolean copyTo(File file, XMLWriter xml) throws IOException {
        boolean ok = false;
        if (file.exists()) {
            try {
                XMLStringWriter copy = new XMLStringWriter(XML.NamespaceAware.No);
                XMLCopy.parse(new XMLCopy((XMLWriter)copy), new InputSource(file.toURI().toString()));
                copy.flush();
                String parsed = copy.toString();
                xml.writeXML(parsed);
                ok = true;
            }
            catch (BerliozException ex) {
                LOGGER.warn("An error was reported by the parser while parsing {}", (Object)file.toURI());
                XMLCopy.handleError(xml, ex);
            }
        } else {
            LOGGER.warn("Could not find {}", (Object)file.toURI());
            xml.openElement("no-data");
            xml.attribute("error", "file-not-found");
            xml.closeElement();
        }
        return ok;
    }

    public static boolean copyTo(Reader reader, XMLWriter xml) throws IOException {
        boolean ok = false;
        try {
            XMLStringWriter copy = new XMLStringWriter(XML.NamespaceAware.No);
            XMLCopy.parse(new XMLCopy((XMLWriter)copy), new InputSource(reader));
            copy.flush();
            String parsed = copy.toString();
            xml.writeXML(parsed);
            ok = true;
        }
        catch (BerliozException ex) {
            LOGGER.warn("An error was reported by the parser while parsing reader");
            XMLCopy.handleError(xml, ex);
        }
        return ok;
    }

    private static void parse(XMLCopy copier, InputSource source) throws BerliozException {
        SAXParser parser = XMLUtils.getParser(false);
        try {
            XMLReader xmlreader = parser.getXMLReader();
            xmlreader.setContentHandler(copier);
            XMLCopy.trySettingLexicalHandler(xmlreader, copier);
            xmlreader.setEntityResolver(BerliozEntityResolver.getInstance());
            xmlreader.setErrorHandler(BerliozErrorHandler.getInstance());
            xmlreader.parse(source);
        }
        catch (SAXException ex) {
            throw new BerliozException("Could not parse file. " + ex.getMessage(), ex);
        }
        catch (IOException ex) {
            LOGGER.error("Could not read file.", (Throwable)ex);
            throw new BerliozException("Could not read file.", ex);
        }
    }

    private static void trySettingLexicalHandler(XMLReader xmlreader, XMLCopy copier) {
        if (supportsComments) {
            try {
                xmlreader.setProperty(LEXICAL_HANDLER_PROPERTY, copier);
            }
            catch (SAXNotRecognizedException | SAXNotSupportedException ex) {
                supportsComments = false;
                LOGGER.warn("Unable to copy comments", (Throwable)ex);
            }
        }
    }

    private static void handleError(XMLWriter xml, Exception ex) throws IOException {
        String m = ex.getMessage();
        Throwable cause = ex.getCause();
        LOGGER.warn("Error details:", (Throwable)ex);
        xml.openElement("no-data");
        xml.attribute("error", "parsing");
        xml.attribute("details", m != null ? m : "(No message)");
        if (cause instanceof SAXParseException) {
            SAXParseException sax = (SAXParseException)cause;
            xml.attribute("line", sax.getLineNumber());
            xml.attribute("column", sax.getColumnNumber());
        }
        xml.closeElement();
    }
}

