/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.util;

import java.io.IOException;
import java.util.Objects;
import org.pageseeder.berlioz.util.Errors;
import org.pageseeder.xmlwriter.XMLWritable;
import org.pageseeder.xmlwriter.XMLWriter;

public final class CollectedError<T extends Throwable>
implements XMLWritable {
    private final Level _level;
    private final T _error;

    public CollectedError(Level level, T error) {
        this._level = Objects.requireNonNull(level, "The level is required");
        this._error = (Throwable)Objects.requireNonNull(error, "The error is required");
    }

    public Level level() {
        return this._level;
    }

    public T error() {
        return this._error;
    }

    public void toXML(XMLWriter xml) throws IOException {
        xml.openElement("collected");
        xml.attribute("level", this._level.toString());
        Errors.toXML(this._error, xml, false);
        xml.closeElement();
    }

    public static enum Level {
        WARNING,
        ERROR,
        FATAL;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

