/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.system;

import org.eclipse.jdt.annotation.Nullable;

final class Threads {
    private Threads() {
    }

    protected static ThreadGroup getRootThreadGroup() {
        ThreadGroup parent;
        ThreadGroup current = Thread.currentThread().getThreadGroup();
        if (current == null) {
            throw new IllegalStateException("The current thread has died?");
        }
        while ((parent = current.getParent()) != null) {
            current = parent;
        }
        return current;
    }

    protected static @Nullable Thread getThread(long id) {
        ThreadGroup root = Threads.getRootThreadGroup();
        Thread[] threads = new Thread[root.activeCount()];
        while (root.enumerate(threads, true) == threads.length) {
            threads = new Thread[threads.length * 2];
        }
        for (Thread t : threads) {
            if (t.getId() != id) continue;
            return t;
        }
        return null;
    }

    protected static String toThreadGroupName(Thread thread) {
        ThreadGroup group = thread.getThreadGroup();
        if (group == null) {
            return "(No thread group)";
        }
        String groupName = group.getName();
        return groupName != null ? groupName : "(No thread group Name)";
    }
}

