/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.system;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.pageseeder.berlioz.Beta;
import org.pageseeder.berlioz.content.ContentGenerator;
import org.pageseeder.berlioz.content.ContentRequest;
import org.pageseeder.xmlwriter.XMLWriter;

@Beta
public final class GetFileSystemInfo
implements ContentGenerator {
    @Override
    public void process(ContentRequest req, XMLWriter xml) throws IOException {
        File pub = req.getEnvironment().getPublicFolder();
        File priv = req.getEnvironment().getPrivateFolder();
        xml.openElement("file-system");
        xml.attribute("free-space", Long.toString(pub.getFreeSpace()));
        xml.attribute("total-space", Long.toString(pub.getTotalSpace()));
        if ("true".equals(req.getParameter("details"))) {
            GetFileSystemInfo.analyze(pub, "public", xml);
            GetFileSystemInfo.analyze(priv, "private", xml);
        }
        xml.closeElement();
    }

    private static void analyze(File dir, String name, XMLWriter xml) throws IOException {
        DirInfo global = new DirInfo(name);
        ArrayList<DirInfo> locals = new ArrayList<DirInfo>();
        File[] files = dir.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    if ("WEB-INF".equals(f.getName())) continue;
                    DirInfo local = new DirInfo(f.getName());
                    GetFileSystemInfo.analyze(local, f);
                    locals.add(local);
                    continue;
                }
                global.add(f);
            }
        }
        xml.openElement(name);
        for (DirInfo local : locals) {
            global.add(local);
        }
        xml.attribute("total-size", Long.toString(global.getSize()));
        xml.attribute("total-count", global.getCount());
        for (DirInfo local : locals) {
            xml.openElement("directory");
            xml.attribute("name", local.name());
            xml.attribute("file-size", Long.toString(local.getSize()));
            xml.attribute("file-count", local.getCount());
            xml.closeElement();
        }
        xml.closeElement();
    }

    private static void analyze(DirInfo local, File dir) {
        File[] files = dir.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    GetFileSystemInfo.analyze(local, f);
                    continue;
                }
                local.add(f);
            }
        }
    }

    private static class DirInfo {
        private final String _name;
        private long size = 0L;
        private int count = 0;

        public DirInfo(String name) {
            this._name = name;
        }

        public void add(File f) {
            this.size += f.length();
            ++this.count;
        }

        public void add(DirInfo info) {
            this.size += info.getSize();
            this.count += info.getCount();
        }

        public String name() {
            return this._name;
        }

        public long getSize() {
            return this.size;
        }

        public int getCount() {
            return this.count;
        }
    }
}

