/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.servlet;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Objects;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.berlioz.BerliozOption;
import org.pageseeder.berlioz.GlobalSettings;
import org.pageseeder.berlioz.InitEnvironment;
import org.pageseeder.berlioz.LifecycleListener;
import org.pageseeder.berlioz.servlet.Overlays;
import org.slf4j.ILoggerFactory;
import org.slf4j.LoggerFactory;

public abstract class AppInitializer {
    private final List<LifecycleListener> _listeners;
    private final File _webinf;

    public AppInitializer(File webinf, List<LifecycleListener> listeners) {
        this._webinf = Objects.requireNonNull(webinf, "Listeners must be specified");
        this._listeners = Objects.requireNonNull(listeners, "Listeners must be specified");
    }

    public final void init() {
        String mode;
        AppInitializer.console(Phase.INIT, "===============================================================");
        AppInitializer.console(Phase.INIT, "Initialing Berlioz " + GlobalSettings.getVersion() + "...");
        AppInitializer.console(Phase.INIT, "Application base: " + this._webinf.getAbsolutePath());
        InitEnvironment env = InitEnvironment.create(this._webinf);
        String configFolder = this.setupConfigFolder(this._webinf);
        env = env.configFolder(configFolder);
        @Nullable File appData = this.configureAppData();
        if (appData != null) {
            env = env.appData(appData);
        }
        if ((mode = this.configureMode(appData != null ? appData : this._webinf, configFolder)) != null) {
            env = env.mode(mode);
        }
        GlobalSettings.setup(env);
        this.deployOverlays();
        AppInitializer.checkServices(env);
        AppInitializer.configureLogger(env);
        this.addLifecycleListener();
        AppInitializer.loadSettings();
        this.startListeners();
        AppInitializer.console(Phase.INIT, "Done!");
        AppInitializer.console(Phase.INIT, "===============================================================");
    }

    public final void destroy() {
        AppInitializer.console(Phase.STOP, "===============================================================");
        AppInitializer.console(Phase.STOP, "Stopping Berlioz " + GlobalSettings.getVersion() + "...");
        AppInitializer.console(Phase.STOP, "Application Base: " + this._webinf.getAbsolutePath());
        if (this._listeners.size() > 0) {
            AppInitializer.console(Phase.STOP, "Lifecycle: Invoking listeners");
            for (LifecycleListener listener : this._listeners) {
                try {
                    listener.stop();
                }
                catch (Exception ex) {
                    System.out.println("[BERLIOZ_STOP] (!) Unable to stop Lifecycle listener: " + listener.getClass().getSimpleName());
                }
            }
            this._listeners.clear();
        } else {
            AppInitializer.console(Phase.STOP, "Lifecycle: OK (No listener)");
        }
        AppInitializer.console(Phase.STOP, "Bye now!");
        AppInitializer.console(Phase.STOP, "===============================================================");
    }

    abstract @Nullable String getAppDataPath();

    abstract String getConfigFolder();

    abstract @Nullable String getMode();

    abstract void deployOverlays();

    abstract void addLifecycleListener();

    public static AppInitializer newInstance(File root, List<LifecycleListener> listeners) {
        return new SystemInitializer(root, listeners);
    }

    public static AppInitializer newInstance(ServletContext context, List<LifecycleListener> listeners) {
        return new ServletContextInitializer(context, listeners);
    }

    public static AppInitializer newInstance(ServletConfig config, List<LifecycleListener> listeners) {
        return new ServletConfigInitializer(config, listeners);
    }

    private String setupConfigFolder(File webinf) {
        String configFolder = this.getConfigFolder();
        try {
            File config = new File(webinf, configFolder);
            if (!configFolder.matches("^[0-9a-zA-Z_]+$")) {
                AppInitializer.console(Phase.INIT, "Config folder: (!) The specified config folder '" + configFolder + "' is not recommended");
            }
            if (!config.exists()) {
                throw new IOException("The specified config folder '/WEB-INF/" + configFolder + "' does not exist.");
            }
            if (!config.isDirectory()) {
                throw new IOException("The specified config folder '/WEB-INF/" + configFolder + "' is not a directory.");
            }
            AppInitializer.console(Phase.INIT, "Config folder: Using '" + configFolder + "'");
        }
        catch (IOException ex) {
            AppInitializer.console(Phase.INIT, "(!) Unable to setup application config folder");
            AppInitializer.console(Phase.INIT, "(!) " + ex.getMessage());
        }
        return configFolder;
    }

    private @Nullable File configureAppData() {
        @Nullable File appData = null;
        try {
            @Nullable String appDataPath = this.getAppDataPath();
            if (appDataPath != null) {
                appData = new File(appDataPath);
                if (!appData.exists()) {
                    Files.createDirectories(appData.toPath(), new FileAttribute[0]);
                    AppInitializer.console(Phase.INIT, "AppData: created specified appdata folder");
                } else if (!appData.isDirectory()) {
                    throw new IOException("The specified appdata folder " + appData + " is not a directory.");
                }
                AppInitializer.console(Phase.INIT, "AppData: '" + appData.getAbsolutePath() + "'");
            } else {
                AppInitializer.console(Phase.INIT, "AppData: default to Web application /WEB-INF folder");
            }
            AppInitializer.console(Phase.INIT, "AppData: OK ---------------------------------------------------");
        }
        catch (IOException ex) {
            appData = null;
            AppInitializer.console(Phase.INIT, "(!) Unable to setup application data folder");
            AppInitializer.console(Phase.INIT, "(!) " + ex.getMessage());
            AppInitializer.console(Phase.INIT, "AppData: FAIL --------------------------------------------------");
        }
        return appData;
    }

    private String configureMode(File appData, String configFolder) {
        @Nullable String mode = this.getMode();
        if (mode == null) {
            mode = AppInitializer.autoDetect(new File(appData, configFolder));
            if (mode != null) {
                AppInitializer.console(Phase.INIT, "Mode: auto-detected modes configuration file.");
            } else {
                AppInitializer.console(Phase.INIT, "Mode: defaulting to default");
                mode = "default";
            }
        }
        AppInitializer.console(Phase.INIT, "Mode: '" + mode + "'");
        AppInitializer.console(Phase.INIT, "Mode: OK ------------------------------------------------------");
        return mode;
    }

    private static @Nullable String autoDetect(File directory) {
        @Nullable String mode = null;
        @Nullable String[] filenames = directory.list();
        if (filenames != null) {
            for (String name : filenames) {
                if (!name.startsWith("config-") || !name.endsWith(".xml")) continue;
                if (mode == null) {
                    int prefix = 7;
                    int suffix = 4;
                    mode = name.substring(7, name.length() - 4);
                    continue;
                }
                AppInitializer.console(Phase.INIT, "(!) Multiple modes to choose from!");
                AppInitializer.console(Phase.INIT, "(!) Use 'berlioz.mode' or specify only 1 'config-[mode].xml'");
                mode = null;
            }
        } else {
            AppInitializer.console(Phase.INIT, "(!) Unable to list config files!");
        }
        return mode;
    }

    protected static void checkOverlays(File contextPath) {
        List<Overlays.Overlay> overlays = Overlays.list(contextPath);
        AppInitializer.console(Phase.INIT, "Overlays: found '" + overlays.size() + "' overlay(s)");
        @Nullable Overlays.Overlay previous = null;
        for (Overlays.Overlay o : overlays) {
            if (previous != null && previous.name().equals(o.name())) {
                AppInitializer.console(Phase.INIT, "(!) Multiple versions of the same overlay found!");
            }
            previous = o;
            try {
                File f = o.getSource();
                AppInitializer.console(Phase.INIT, "Overlays: unpacking '" + f.getName() + "'");
                int count = o.unpack(contextPath);
                AppInitializer.console(Phase.INIT, "Overlays: '" + f.getName() + "' - " + count + " files unpacked");
            }
            catch (IOException ex) {
                AppInitializer.console(Phase.INIT, "(!) Unable to unpack overlay: " + ex.getMessage());
            }
        }
    }

    private static void checkServices(InitEnvironment env) {
        Path services = env.webInf().toPath().resolve(env.configFolder() + "/services.xml");
        if (Files.exists(services, new LinkOption[0])) {
            AppInitializer.console(Phase.INIT, "Services: found " + env.configFolder() + "/services.xml");
            AppInitializer.console(Phase.INIT, "Services: OK --------------------------------------------------");
        } else {
            AppInitializer.console(Phase.INIT, "(!) Could not find " + env.configFolder() + "/services.xml");
            AppInitializer.console(Phase.INIT, "Services: FAIL ------------------------------------------------");
        }
    }

    private static void configureLogger(InitEnvironment env) {
        File appDataConfig = new File(env.appData(), env.configFolder());
        File webInfConfig = new File(env.webInf(), env.configFolder());
        File file = new File(appDataConfig, "logback-" + env.mode() + ".xml");
        boolean configured = AppInitializer.configureLogback(file);
        if (configured) {
            return;
        }
        if (env.hasAppData() && (configured = AppInitializer.configureLogback(file = new File(webInfConfig, "logback-" + env.mode() + ".xml")))) {
            return;
        }
        file = new File(webInfConfig, "logback.xml");
        configured = AppInitializer.configureLogback(file);
        if (configured) {
            return;
        }
        file = new File(appDataConfig, "log4j-" + env.mode() + ".properties");
        configured = AppInitializer.configureLog4j(file);
        if (configured) {
            return;
        }
        if (env.hasAppData() && (configured = AppInitializer.configureLog4j(file = new File(webInfConfig, "log4j-" + env.mode() + ".properties")))) {
            return;
        }
        file = new File(webInfConfig, "log4j.properties");
        configured = AppInitializer.configureLog4j(file);
        if (configured) {
            return;
        }
        AppInitializer.console(Phase.INIT, "Logging: no logging configured.");
        AppInitializer.console(Phase.INIT, "Logging: DONE -------------------------------------------------");
    }

    private static boolean configureLogback(File configuration) {
        boolean configured = false;
        if (configuration.exists()) {
            AppInitializer.console(Phase.INIT, "Logging: found config/" + configuration.getName() + " [logback config file]");
            try {
                Class<?> joranClass = Class.forName("ch.qos.logback.classic.joran.JoranConfigurator");
                Class<?> contextClass = Class.forName("ch.qos.logback.core.Context");
                Object configurator = joranClass.newInstance();
                ILoggerFactory context = LoggerFactory.getILoggerFactory();
                Method setContext = joranClass.getMethod("setContext", contextClass);
                setContext.invoke(configurator, contextClass.cast(context));
                try {
                    Class<?> loggerContextClass = Class.forName("ch.qos.logback.classic.LoggerContext");
                    Method reset = loggerContextClass.getMethod("reset", new Class[0]);
                    reset.invoke((Object)context, new Object[0]);
                    AppInitializer.console(Phase.INIT, "Logging: logger context reset successfully");
                }
                catch (Exception ex) {
                    AppInitializer.console(Phase.INIT, "(!) Logging: Failed to  logger context - logging messages may appear twice");
                    ex.printStackTrace();
                }
                Method doConfigure = joranClass.getMethod("doConfigure", String.class);
                doConfigure.invoke(configurator, configuration.getAbsolutePath());
                configured = true;
                AppInitializer.console(Phase.INIT, "Logging: logback config file OK");
                AppInitializer.console(Phase.INIT, "Logging: OK ---------------------------------------------------");
            }
            catch (ClassNotFoundException ex) {
                AppInitializer.console(Phase.INIT, "(!) Logging: attempt to load logback configuration failed!");
                AppInitializer.console(Phase.INIT, "(!) Logging: logback could not be found on classpath!");
            }
            catch (Exception ex) {
                AppInitializer.console(Phase.INIT, "(!) Logging: attempt to load Logback configuration failed!");
                ex.printStackTrace();
            }
        } else {
            AppInitializer.console(Phase.INIT, "Logging: config/" + configuration.getName() + " not found");
        }
        return configured;
    }

    private static boolean configureLog4j(File configuration) {
        boolean configured = false;
        if (configuration.exists()) {
            AppInitializer.console(Phase.INIT, "Logging: found config/" + configuration.getName() + " [log4j config file]");
            try {
                Class<?> configurator = Class.forName("org.apache.log4j.PropertyConfigurator");
                Method m = configurator.getDeclaredMethod("configure", String.class);
                m.invoke(null, configuration.getAbsolutePath());
                configured = true;
                AppInitializer.console(Phase.INIT, "Logging: log4j config file OK");
                AppInitializer.console(Phase.INIT, "Logging: OK ---------------------------------------------------");
            }
            catch (ClassNotFoundException ex) {
                AppInitializer.console(Phase.INIT, "(!) Logging: attempt to load Log4j configuration failed!");
                AppInitializer.console(Phase.INIT, "(!) Logging: Log4j could not be found on classpath!");
            }
            catch (Exception ex) {
                AppInitializer.console(Phase.INIT, "(!) Logging: attempt to load Log4j configuration failed!");
                ex.printStackTrace();
            }
        } else {
            AppInitializer.console(Phase.INIT, "Logging: config/" + configuration.getName() + " not found");
        }
        return configured;
    }

    private static void loadSettings() {
        @Nullable File modeConfigFile = GlobalSettings.getModeConfigFile();
        @Nullable File defaultConfigFile = GlobalSettings.getDefaultConfigFile();
        String mode = GlobalSettings.getMode();
        if (modeConfigFile != null || defaultConfigFile != null) {
            boolean loaded;
            @Nullable File appdata = GlobalSettings.getAppData();
            @Nullable File webinf = GlobalSettings.getWebInf();
            if (modeConfigFile != null && appdata != null) {
                AppInitializer.console(Phase.INIT, "Config: found [appdata]/" + AppInitializer.toRelPath(modeConfigFile, appdata));
            }
            if (defaultConfigFile != null && webinf != null) {
                AppInitializer.console(Phase.INIT, "Config: found [webinf]/" + AppInitializer.toRelPath(defaultConfigFile, webinf));
            }
            if (loaded = GlobalSettings.load()) {
                AppInitializer.console(Phase.INIT, "Config: loaded OK (" + GlobalSettings.countProperties() + " properties found)");
                AppInitializer.console(Phase.INIT, "Config: HTTP Compression = " + GlobalSettings.get(BerliozOption.HTTP_COMPRESSION));
                AppInitializer.console(Phase.INIT, "Config: XSLT Caching = " + GlobalSettings.get(BerliozOption.XSLT_CACHE));
                AppInitializer.console(Phase.INIT, "Config: XML Strict Parse = " + GlobalSettings.get(BerliozOption.XML_PARSE_STRICT));
                AppInitializer.console(Phase.INIT, "Config: XML Header Version = " + GlobalSettings.get(BerliozOption.XML_HEADER_VERSION));
                AppInitializer.console(Phase.INIT, "Config: OK ----------------------------------------------------");
            } else {
                AppInitializer.console(Phase.INIT, "(!) Unable to load global settings ");
                AppInitializer.console(Phase.INIT, "Config: FAIL --------------------------------------------------");
            }
        } else {
            AppInitializer.console(Phase.INIT, "(!) Could not find config.xml, config.properties, config-" + mode + ".xml or config-" + mode + ".properties");
            AppInitializer.console(Phase.INIT, "Config: FAIL --------------------------------------------------");
        }
    }

    protected void registerListener(String listenerClass) {
        @Nullable LifecycleListener listener = null;
        try {
            Class<?> c = Class.forName(listenerClass);
            listener = (LifecycleListener)c.newInstance();
        }
        catch (ClassNotFoundException ex) {
            AppInitializer.console(Phase.INIT, "Lifecycle: (!) Unable to find class for listener:");
            AppInitializer.console(Phase.INIT, "  " + listenerClass);
        }
        catch (ClassCastException ex) {
            AppInitializer.console(Phase.INIT, "Lifecycle: (!) Class does not implement LifecycleListener:");
            AppInitializer.console(Phase.INIT, "  " + listenerClass);
        }
        catch (IllegalAccessException ex) {
            AppInitializer.console(Phase.INIT, "Lifecycle: (!) Unable to access lifecycle listener:");
            AppInitializer.console(Phase.INIT, "  " + ex.getMessage());
        }
        catch (InstantiationException ex) {
            AppInitializer.console(Phase.INIT, "Lifecycle: (!) Unable to instantiate lifecycle listener:");
            AppInitializer.console(Phase.INIT, "  " + ex.getMessage());
        }
        if (listener != null) {
            this._listeners.add(listener);
        }
    }

    private void startListeners() {
        if (this._listeners.size() > 0) {
            boolean ok = true;
            for (LifecycleListener listener : this._listeners) {
                try {
                    ok = ok && listener.start();
                    AppInitializer.console(Phase.INIT, "Lifecycle: started " + listener.getClass().getSimpleName());
                }
                catch (Exception ex) {
                    ok = false;
                    ex.printStackTrace();
                }
            }
            if (ok) {
                AppInitializer.console(Phase.INIT, "Lifecycle: OK -------------------------------------------------");
            } else {
                AppInitializer.console(Phase.INIT, "(!) Unable to start Lifecycle listener");
                AppInitializer.console(Phase.INIT, "Lifecycle: FAIL -----------------------------------------------");
            }
        } else {
            AppInitializer.console(Phase.INIT, "Lifecycle: OK (No listeners)");
        }
    }

    private static String toRelPath(File file, File base) {
        String b;
        String p = file.getPath();
        if (p.startsWith(b = base.getPath()) && p.length() > b.length()) {
            return p.substring(b.length() + 1).replace('\\', '/');
        }
        return p;
    }

    private static void console(Phase phase, String message) {
        System.out.println("[BERLIOZ_" + (Object)((Object)phase) + "] " + message);
    }

    private static class SystemInitializer
    extends AppInitializer {
        private final File _root;

        public SystemInitializer(File root, List<LifecycleListener> listeners) {
            super(new File(root, "WEB-INF"), listeners);
            this._root = root;
        }

        @Override
        String getConfigFolder() {
            String config = System.getProperty("berlioz.config");
            if (config != null) {
                AppInitializer.console(Phase.INIT, "Config folder: defined with system property 'berlioz.config'");
                return config;
            }
            config = System.getenv("BERLIOZ_CONFIG");
            if (config != null) {
                AppInitializer.console(Phase.INIT, "Config folder: defined with environment variable 'BERLIOZ_CONFIG'");
                return config;
            }
            return "config";
        }

        @Override
        @Nullable String getAppDataPath() {
            String appdata = System.getProperty("berlioz.appdata");
            if (appdata != null) {
                AppInitializer.console(Phase.INIT, "AppData: defined with system property 'berlioz.appdata'");
                return appdata;
            }
            appdata = System.getenv("BERLIOZ_APPDATA");
            if (appdata != null) {
                AppInitializer.console(Phase.INIT, "AppData: defined with environment variable 'BERLIOZ_APPDATA'");
                return appdata;
            }
            return null;
        }

        @Override
        @Nullable String getMode() {
            String mode = System.getProperty("berlioz.mode");
            if (mode != null) {
                AppInitializer.console(Phase.INIT, "Mode: defined with system property 'berlioz.mode'");
                return mode;
            }
            mode = System.getenv("BERLIOZ_MODE");
            if (mode != null) {
                AppInitializer.console(Phase.INIT, "Mode: defined with environment variable 'BERLIOZ_MODE'");
                return mode;
            }
            return null;
        }

        @Override
        void deployOverlays() {
            SystemInitializer.checkOverlays(this._root);
        }

        @Override
        void addLifecycleListener() {
        }
    }

    private static class ServletContextInitializer
    extends SystemInitializer {
        private final ServletContext _context;

        public ServletContextInitializer(ServletContext context, List<LifecycleListener> listeners) {
            super(new File(context.getRealPath("/")), listeners);
            this._context = Objects.requireNonNull(context, "Servlet context must be specified");
        }

        @Override
        String getConfigFolder() {
            String config = this._context.getInitParameter("berlioz.config");
            if (config != null) {
                AppInitializer.console(Phase.INIT, "Config folder: defined with servlet init-parameter 'berlioz.config'");
                return config;
            }
            return super.getConfigFolder();
        }

        @Override
        @Nullable String getAppDataPath() {
            String appdata = this._context.getInitParameter("berlioz.appdata");
            if (appdata != null) {
                AppInitializer.console(Phase.INIT, "AppData: defined with context init-parameter 'berlioz.appdata'");
                return appdata;
            }
            return super.getAppDataPath();
        }

        @Override
        @Nullable String getMode() {
            String mode = this._context.getInitParameter("berlioz.mode");
            if (mode != null) {
                AppInitializer.console(Phase.INIT, "Mode: defined with context init-parameter 'berlioz.mode'");
                return mode;
            }
            return super.getMode();
        }

        @Override
        void deployOverlays() {
            File contextPath = new File(this._context.getRealPath("/"));
            ServletContextInitializer.checkOverlays(contextPath);
        }

        @Override
        void addLifecycleListener() {
            String listenerClass = this._context.getInitParameter("berlioz.lifecycle-listener");
            if (listenerClass != null) {
                this.registerListener(listenerClass);
            }
            super.addLifecycleListener();
        }
    }

    private static class ServletConfigInitializer
    extends ServletContextInitializer {
        private final ServletConfig _config;

        public ServletConfigInitializer(ServletConfig config, List<LifecycleListener> listeners) {
            super(config.getServletContext(), listeners);
            this._config = Objects.requireNonNull(config, "Servlet config must be specified");
        }

        @Override
        String getConfigFolder() {
            String config = this._config.getInitParameter("config");
            if (config != null) {
                AppInitializer.console(Phase.INIT, "Config folder: defined with servlet init-parameter 'config'");
                return config;
            }
            return super.getConfigFolder();
        }

        @Override
        @Nullable String getAppDataPath() {
            String appdata = this._config.getInitParameter("appdata");
            if (appdata != null) {
                AppInitializer.console(Phase.INIT, "AppData: defined with servlet init-parameter 'appdata'");
                return appdata;
            }
            return super.getAppDataPath();
        }

        @Override
        @Nullable String getMode() {
            String mode = this._config.getInitParameter("mode");
            if (mode != null) {
                AppInitializer.console(Phase.INIT, "Mode: defined with servlet init-parameter 'mode'");
                return mode;
            }
            return super.getMode();
        }

        @Override
        void addLifecycleListener() {
            String listenerClass = this._config.getInitParameter("lifecycle-listener");
            if (listenerClass != null) {
                this.registerListener(listenerClass);
            }
            super.addLifecycleListener();
        }
    }

    private static enum Phase {
        INIT,
        STOP;

    }
}

