/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.security;

import java.util.EnumMap;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.berlioz.security.Directive;

public final class ContentSecurityPolicy {
    private final EnumMap<Directive, String> directives;

    private ContentSecurityPolicy(EnumMap<Directive, String> directives) {
        this.directives = directives;
    }

    public @Nullable String get(Directive directive) {
        return this.directives.get((Object)directive);
    }

    public Builder builder() {
        return new Builder(this);
    }

    public boolean isEmpty() {
        return this.directives.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContentSecurityPolicy that = (ContentSecurityPolicy)o;
        return this.directives.equals((Object)that.directives);
    }

    public int hashCode() {
        return this.directives.hashCode();
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        for (Map.Entry<Directive, String> e : this.directives.entrySet()) {
            if (out.length() > 0) {
                out.append("; ");
            }
            out.append((Object)e.getKey());
            if (e.getValue().length() <= 0) continue;
            out.append(' ').append(e.getValue());
        }
        return out.toString();
    }

    public ContentSecurityPolicy withValue(Directive directive, String value) {
        return this.builder().set(directive, value).buildPrivate();
    }

    public ContentSecurityPolicy withSource(Directive directive, String source) {
        return this.builder().add(directive, source).buildPrivate();
    }

    public ContentSecurityPolicy withNonce(Directive directive, String nonce) {
        return this.builder().nonce(directive, nonce).buildPrivate();
    }

    public ContentSecurityPolicy without(Directive directive) {
        return this.builder().remove(directive).buildPrivate();
    }

    public static class Builder {
        private final EnumMap<Directive, String> directives;

        public Builder() {
            this.directives = new EnumMap(Directive.class);
        }

        public Builder(ContentSecurityPolicy policy) {
            this.directives = policy.directives.clone();
        }

        public Builder set(Directive directive, String value) {
            this.directives.put(directive, value);
            return this;
        }

        public Builder add(Directive directive, String source) {
            String current = this.directives.get((Object)directive);
            this.set(directive, current != null && current.length() > 0 ? current + " " + source : source);
            return this;
        }

        public Builder nonce(Directive directive, String nonce) {
            return this.add(directive, "'nonce-" + nonce + "'");
        }

        public Builder remove(Directive directive) {
            this.directives.remove((Object)directive);
            return this;
        }

        public ContentSecurityPolicy build() {
            return new ContentSecurityPolicy((EnumMap)this.directives.clone());
        }

        private ContentSecurityPolicy buildPrivate() {
            return new ContentSecurityPolicy(this.directives);
        }
    }
}

