/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.json;

import java.io.PrintWriter;
import java.util.Arrays;
import org.pageseeder.berlioz.json.JsonWriter;

final class BuiltinJsonWriter
implements JsonWriter {
    private final PrintWriter _json;
    private char[] closer = new char[64];
    private int level = -1;
    private boolean needComma = false;

    public BuiltinJsonWriter(PrintWriter json) {
        this._json = json;
    }

    @Override
    public JsonWriter startArray(String name) {
        this.push(']');
        this.maybeAppendComma(true);
        this.appendJSONString(name);
        this._json.append(':');
        this._json.append('[');
        return this;
    }

    @Override
    public JsonWriter startArray() {
        this.push(']');
        this.maybeAppendComma(true);
        this._json.append('[');
        return this;
    }

    @Override
    public JsonWriter endArray() {
        if (this.level < 0) {
            throw new IllegalStateException("Nothing to end!");
        }
        this._json.append(this.closer[this.level--]);
        this.needComma = true;
        return this;
    }

    @Override
    public JsonWriter startObject(String name) {
        this.push('}');
        this.maybeAppendComma(true);
        this.appendJSONString(name);
        this._json.append(':');
        this._json.append('{');
        return this;
    }

    @Override
    public JsonWriter startObject() {
        this.push('}');
        this.maybeAppendComma(true);
        this._json.append('{');
        return this;
    }

    @Override
    public JsonWriter endObject() {
        if (this.level < 0) {
            throw new IllegalStateException("Nothing to end!");
        }
        this._json.append(this.closer[this.level--]);
        this.needComma = true;
        return this;
    }

    @Override
    public JsonWriter nullValue(String name) {
        this.maybeAppendComma(false);
        this.appendJSONString(name);
        this._json.append(':');
        this._json.append("null");
        return this;
    }

    @Override
    public JsonWriter nullValue() {
        this.maybeAppendComma(false);
        this._json.append("null");
        return this;
    }

    @Override
    public JsonWriter value(double number) {
        this.maybeAppendComma(false);
        this.appendJsonDouble(number);
        return this;
    }

    @Override
    public JsonWriter value(long number) {
        this.maybeAppendComma(false);
        this.appendJsonLong(number);
        return this;
    }

    @Override
    public JsonWriter value(String value) {
        this.maybeAppendComma(false);
        this.appendJSONString(value);
        return this;
    }

    @Override
    public JsonWriter value(boolean value) {
        this.maybeAppendComma(false);
        this.appendJsonBoolean(value);
        return this;
    }

    @Override
    public JsonWriter name(String name) {
        this.maybeAppendComma(false);
        this.appendJSONString(name);
        this._json.append(':');
        this.needComma = false;
        return this;
    }

    @Override
    public JsonWriter field(String name, String value) {
        this.maybeAppendComma(false);
        this.appendJSONString(name);
        this._json.append(':');
        this.appendJSONString(value);
        return this;
    }

    @Override
    public JsonWriter field(String name, boolean value) {
        this.maybeAppendComma(false);
        this.appendJSONString(name);
        this._json.append(':');
        this.appendJsonBoolean(value);
        return this;
    }

    @Override
    public JsonWriter field(String name, double value) {
        this.maybeAppendComma(false);
        this.appendJSONString(name);
        this._json.append(':');
        this.appendJsonDouble(value);
        return this;
    }

    @Override
    public JsonWriter field(String name, long value) {
        this.maybeAppendComma(false);
        this.appendJSONString(name);
        this._json.append(':');
        this.appendJsonLong(value);
        return this;
    }

    @Override
    public boolean inObject() {
        return this.level >= 0 && this.closer[this.level] == '}';
    }

    @Override
    public void close() {
        this._json.close();
    }

    @Override
    public void flush() {
        this._json.flush();
    }

    private void appendJSONString(String s) {
        this._json.append('\"');
        int _length = s.length();
        block7: for (int i = 0; i < _length; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\n': {
                    this._json.append('\\').append('n');
                    continue block7;
                }
                case '\r': {
                    this._json.append('\\').append('r');
                    continue block7;
                }
                case '\t': {
                    this._json.append('\\').append('t');
                    continue block7;
                }
                case '\"': {
                    this._json.append('\\').append('\"');
                    continue block7;
                }
                case '\\': {
                    this._json.append('\\').append('\\');
                    continue block7;
                }
                default: {
                    if (c < '\u0010') {
                        this._json.append("\\u000").append(Integer.toHexString(c));
                        continue block7;
                    }
                    if (c < ' ') {
                        this._json.append("\\u00").append(Integer.toHexString(c));
                        continue block7;
                    }
                    this._json.append(c);
                }
            }
        }
        this._json.append('\"');
    }

    private void appendJsonLong(long number) {
        this._json.append(Long.toString(number));
    }

    private void appendJsonDouble(double number) {
        this._json.append(Double.toString(number));
    }

    private void appendJsonBoolean(boolean b) {
        this._json.append(Boolean.toString(b));
    }

    private void maybeAppendComma(boolean newContext) {
        if (this.needComma) {
            this._json.append(',');
        } else if (!newContext) {
            this.needComma = true;
        }
    }

    private void push(char c) {
        ++this.level;
        if (this.level < this.closer.length) {
            this.closer[this.level] = c;
        } else {
            this.closer = Arrays.copyOf(this.closer, this.closer.length * 2);
        }
    }
}

