/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.http;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.Nullable;

public final class HttpAcceptHeader {
    private static final Map<String, Map<String, Float>> MAPS = Collections.synchronizedMap(new HashMap());
    private static final int MAX_SIZE = 96;
    private static final Pattern ACCEPT_WITH_QVALUE = Pattern.compile("([^;]+);\\s*q=(\\d\\.?\\d*)\\s*");

    private HttpAcceptHeader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Float> get(@Nullable String accept) {
        if (accept == null || "".equals(accept)) {
            return Collections.emptyMap();
        }
        Map<String, Float> map = MAPS.get(accept);
        if (map == null) {
            map = Collections.unmodifiableMap(HttpAcceptHeader.parse(accept));
            if (MAPS.size() < 96) {
                Map<String, Map<String, Float>> map2 = MAPS;
                synchronized (map2) {
                    MAPS.put(accept, map);
                }
            }
        }
        return map;
    }

    public static boolean accepts(@Nullable String accept, String value) {
        return HttpAcceptHeader.accepts(HttpAcceptHeader.get(accept), value);
    }

    public static boolean accepts(Map<String, Float> accept, String value) {
        Float q = accept.get(value);
        if (q != null && q.floatValue() > 0.0f) {
            return true;
        }
        q = accept.get("*/*");
        if (q != null && q.floatValue() > 0.0f) {
            return true;
        }
        q = accept.get("*");
        if (q != null && q.floatValue() > 0.0f) {
            return true;
        }
        int slash = value.indexOf(47);
        if (slash >= 0) {
            q = accept.get(value.substring(0, slash) + "/*");
            return q != null && q.floatValue() > 0.0f;
        }
        return false;
    }

    protected static Map<String, Float> parse(String accept) {
        LinkedHashMap<String, Float> values = new LinkedHashMap<String, Float>();
        StringTokenizer t = new StringTokenizer(accept, ",");
        while (t.hasMoreElements()) {
            String token = t.nextToken();
            Matcher m = ACCEPT_WITH_QVALUE.matcher(token);
            if (m.matches()) {
                values.put(m.group(1), Float.valueOf(Float.parseFloat(m.group(2))));
                continue;
            }
            values.put(token, Float.valueOf(1.0f));
        }
        return values;
    }

    protected synchronized void clear() {
        MAPS.clear();
    }
}

