/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.furi;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.text.Normalizer;

public final class URICoder {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private URICoder() {
    }

    public static String encode(String s) {
        return URICoder.encode(s, '0');
    }

    public static String encode(String s, char c) {
        if (s.length() == 0) {
            return s;
        }
        boolean ascii = URICoder.isASCII(s);
        return ascii ? URICoder.encodeASCII(s, c) : URICoder.encodeUTF8(s, c);
    }

    public static String minimalEncode(String s) {
        if (s.length() == 0) {
            return s;
        }
        boolean ascii = URICoder.isASCII(s);
        return ascii ? URICoder.minimalEncodeASCII(s) : URICoder.minimalEncodeUTF8(s);
    }

    private static String encodeASCII(String s, char e) {
        StringBuilder sb = new StringBuilder();
        for (char c : s.toCharArray()) {
            if (URICoder.isUnreserved(c) || c == e) {
                sb.append(c);
                continue;
            }
            URICoder.appendEscape(sb, c);
        }
        return sb.toString();
    }

    private static String minimalEncodeASCII(String s) {
        StringBuilder sb = new StringBuilder();
        for (char c : s.toCharArray()) {
            if (URICoder.isLegal(c)) {
                sb.append(c);
                continue;
            }
            URICoder.appendEscape(sb, c);
        }
        return sb.toString();
    }

    private static String encodeUTF8(String s, char e) {
        String n = Normalizer.isNormalized(s, Normalizer.Form.NFKC) ? s : Normalizer.normalize(s, Normalizer.Form.NFKC);
        ByteBuffer bb = StandardCharsets.UTF_8.encode(n);
        StringBuilder sb = new StringBuilder();
        while (bb.hasRemaining()) {
            int b = bb.get() & 0xFF;
            if (URICoder.isUnreserved(b) || b == e) {
                sb.append((char)b);
                continue;
            }
            URICoder.appendEscape(sb, (byte)b);
        }
        return sb.toString();
    }

    private static String minimalEncodeUTF8(String s) {
        String n = Normalizer.isNormalized(s, Normalizer.Form.NFKC) ? s : Normalizer.normalize(s, Normalizer.Form.NFKC);
        ByteBuffer bb = StandardCharsets.UTF_8.encode(n);
        StringBuilder sb = new StringBuilder();
        while (bb.hasRemaining()) {
            int b = bb.get() & 0xFF;
            if (URICoder.isLegal(b)) {
                sb.append((char)b);
                continue;
            }
            URICoder.appendEscape(sb, (byte)b);
        }
        return sb.toString();
    }

    public static String decode(String s) {
        if (s.length() == 0 || s.indexOf(37) < 0 && s.indexOf(43) < 0) {
            return s;
        }
        boolean ascii = URICoder.isEncodedASCII(s);
        return ascii ? URICoder.decodeASCII(s) : URICoder.decodeUTF8(s);
    }

    private static String decodeASCII(String s) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '%') {
                if (i >= s.length() - 2) continue;
                String hex = String.copyValueOf(new char[]{s.charAt(++i), s.charAt(++i)});
                char x = (char)Integer.parseInt(hex, 16);
                sb.append(x);
                continue;
            }
            if (c == '+') {
                sb.append(' ');
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static String decodeUTF8(String s) {
        ByteBuffer bb = ByteBuffer.allocate(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '%') {
                if (i >= s.length() - 2) continue;
                String hex = "" + s.charAt(++i) + s.charAt(++i);
                byte b = (byte)Integer.parseInt(hex, 16);
                bb.put(b);
                continue;
            }
            if (c == '+') {
                bb.put((byte)32);
                continue;
            }
            bb.put((byte)c);
        }
        bb.limit(bb.position());
        bb.position(0);
        return StandardCharsets.UTF_8.decode(bb).toString();
    }

    private static void appendEscape(StringBuilder sb, byte b) {
        sb.append('%');
        sb.append(HEX_DIGITS[b >> 4 & 0xF]);
        sb.append(HEX_DIGITS[b & 0xF]);
    }

    private static void appendEscape(StringBuilder sb, char c) {
        sb.append('%');
        sb.append(HEX_DIGITS[c >> 4 & 0xF]);
        sb.append(HEX_DIGITS[c & 0xF]);
    }

    private static boolean isUnreserved(int c) {
        if (c >= 97 && c <= 122) {
            return true;
        }
        if (c >= 65 && c <= 90) {
            return true;
        }
        if (c >= 48 && c <= 57) {
            return true;
        }
        return c == 46 || c == 95 || c == 45 || c == 126;
    }

    private static boolean isLegal(int c) {
        if (c < 38 && c != 33 && c != 35 && c != 36) {
            return false;
        }
        if (c >= 123 && c != 126) {
            return false;
        }
        return c != 96 && c != 60 && c != 62 && c != 92 && c != 94;
    }

    private static boolean isASCII(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) < '\u0080') continue;
            return false;
        }
        return true;
    }

    private static boolean isEncodedASCII(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != '%' || i >= s.length() - 1 || s.charAt(i + 1) <= '7') continue;
            return false;
        }
        return true;
    }
}

