/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.content;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.xml.parsers.SAXParser;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.berlioz.BerliozErrorID;
import org.pageseeder.berlioz.BerliozException;
import org.pageseeder.berlioz.BerliozOption;
import org.pageseeder.berlioz.GlobalSettings;
import org.pageseeder.berlioz.content.ServiceRegistry;
import org.pageseeder.berlioz.content.ServicesHandler10;
import org.pageseeder.berlioz.util.CollectedError;
import org.pageseeder.berlioz.util.CompoundBerliozException;
import org.pageseeder.berlioz.xml.BerliozEntityResolver;
import org.pageseeder.berlioz.xml.SAXErrorCollector;
import org.pageseeder.berlioz.xml.XMLUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class ServiceLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceLoader.class);
    private static final ServiceLoader singleton = new ServiceLoader();
    private final ServiceRegistry services = new ServiceRegistry();
    private static final FilenameFilter FILE_FILTER = (dir, name) -> name.startsWith("services!") && name.endsWith(".xml");
    private volatile boolean loaded = false;

    private ServiceLoader() {
    }

    public static ServiceLoader getInstance() {
        return singleton;
    }

    public ServiceRegistry getDefaultRegistry() {
        return this.services;
    }

    public synchronized boolean loadIfRequired() throws BerliozException {
        if (this.loaded) {
            return false;
        }
        this.load();
        this.loaded = true;
        return true;
    }

    public synchronized void load() throws BerliozException {
        List<File> files = this.listServiceFiles();
        for (File f : files) {
            this.load(f);
        }
    }

    public List<File> listServiceFiles() {
        List<File> files;
        File config = GlobalSettings.getConfig();
        if (config == null) {
            return Collections.emptyList();
        }
        File xml = new File(config, "services.xml");
        @NonNull File[] subs = config.listFiles(FILE_FILTER);
        if (subs != null && subs.length > 0) {
            files = new ArrayList(subs.length + 1);
            if (xml.exists()) {
                files.add(xml);
            }
            Collections.addAll(files, subs);
        } else {
            files = xml.exists() ? Collections.singletonList(xml) : Collections.emptyList();
        }
        return files;
    }

    public synchronized void load(File xml) throws BerliozException {
        Objects.requireNonNull(xml, "The service configuration file is null! That's it I give up.");
        SAXParser parser = XMLUtils.getParser(true);
        SAXErrorCollector collector = new SAXErrorCollector(LOGGER);
        if (GlobalSettings.has(BerliozOption.XML_PARSE_STRICT)) {
            collector.setErrorFlag(CollectedError.Level.WARNING);
        }
        BerliozErrorID id = null;
        try {
            XMLReader reader = parser.getXMLReader();
            HandlingDispatcher dispatcher = new HandlingDispatcher(reader, this.services);
            reader.setContentHandler(dispatcher);
            reader.setEntityResolver(BerliozEntityResolver.getInstance());
            reader.setErrorHandler(collector);
            LOGGER.info("Parsing {}", (Object)xml.toURI());
            reader.parse(new InputSource(xml.toURI().toString()));
            if (collector.hasError()) {
                id = BerliozErrorID.SERVICES_INVALID;
                throw new SAXException(collector.getErrors().size() + " error(s) reported by the XML parser.");
            }
        }
        catch (SAXException ex) {
            if (id == null) {
                id = BerliozErrorID.SERVICES_MALFORMED;
            }
            LOGGER.error("An SAX error occurred while reading XML service configuration: {}", (Object)ex.getMessage());
            throw new CompoundBerliozException("Unable to parse services configuration file.", ex, id, collector);
        }
        catch (IOException ex) {
            LOGGER.error("An I/O error occurred while reading XML service configuration: {}", (Object)ex.getMessage());
            throw new BerliozException("Unable to read services configuration file.", ex, BerliozErrorID.SERVICES_NOT_FOUND);
        }
        this.services.touch();
    }

    public synchronized void clear() {
        LOGGER.info("Clearing content manager");
        this.services.clear();
        this.loaded = false;
    }

    private static final class HandlingDispatcher
    extends DefaultHandler
    implements ContentHandler {
        private final ServiceRegistry _registry;
        private final XMLReader _reader;
        private @Nullable Locator locator;

        public HandlingDispatcher(XMLReader reader, ServiceRegistry registry) {
            this._reader = reader;
            this._registry = registry;
        }

        @Override
        public void setDocumentLocator(@Nullable Locator locator) {
            this.locator = locator;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            ContentHandler handler = this.getHandler(localName, atts);
            Locator loc = this.locator;
            if (loc != null) {
                handler.setDocumentLocator(loc);
            }
            handler.startDocument();
            handler.startElement(uri, localName, qName, atts);
            this._reader.setContentHandler(handler);
        }

        private ContentHandler getHandler(String name, Attributes atts) throws SAXException {
            SAXErrorCollector collector = this.getErrorCollector(this._reader);
            if ("service-config".equals(name)) {
                String version = atts.getValue("version");
                if ("1.0".equals(version)) {
                    LOGGER.info("Service configuration 1.0 detected");
                    return new ServicesHandler10(this._registry, collector);
                }
                LOGGER.info("Service configuration version unavailable, assuming 1.0");
                return new ServicesHandler10(this._registry, collector);
            }
            if ("services".equals(name)) {
                LOGGER.info("Services group using 1.0");
                return new ServicesHandler10(this._registry, collector);
            }
            LOGGER.error("Unable to determine Berlioz configuration");
            SAXParseException fatal = new SAXParseException("Not a valid Berlioz service configuration!", this.locator);
            collector.fatalError(fatal);
            throw fatal;
        }

        private SAXErrorCollector getErrorCollector(XMLReader reader) {
            ErrorHandler collector = reader.getErrorHandler();
            if (!(collector instanceof SAXErrorCollector)) {
                throw new IllegalStateException("Expected SAX error collector for reader!");
            }
            return (SAXErrorCollector)collector;
        }
    }
}

