/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.content;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.berlioz.Beta;
import org.pageseeder.berlioz.content.Cacheable;
import org.pageseeder.berlioz.content.ContentGenerator;
import org.pageseeder.berlioz.content.Parameter;
import org.pageseeder.berlioz.content.ServiceStatusRule;
import org.pageseeder.berlioz.http.HttpMethod;
import org.pageseeder.xmlwriter.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Service {
    private final String _id;
    private final String _group;
    private final boolean _cacheable;
    private final String _cache;
    private final String _flags;
    private final ServiceStatusRule _rule;
    private final List<ContentGenerator> _generators;
    private final Map<ContentGenerator, List<Parameter>> _parameters;
    private final Map<ContentGenerator, String> _targets;
    private final Map<ContentGenerator, String> _names;

    private Service(Builder builder) {
        this._id = Objects.requireNonNull(builder.id, "The service must have an id");
        this._group = Objects.requireNonNull(builder.group, "The service must belong to a collection (group)");
        this._rule = Objects.requireNonNull(builder.rule, "There must be a rule for this service");
        this._cache = builder.cache;
        this._flags = builder.flags;
        this._generators = Service.immutableList(builder._generators);
        this._parameters = Service.immutableMap(builder._parameters);
        this._cacheable = Service.isCacheable(this._generators);
        this._names = Service.immutable3(builder._names);
        this._targets = Service.immutable3(builder._targets);
    }

    public String id() {
        return this._id;
    }

    public String group() {
        return this._group;
    }

    public String cache() {
        return this._cache;
    }

    public String flags() {
        return this._flags;
    }

    public ServiceStatusRule rule() {
        return this._rule;
    }

    public boolean isCacheable() {
        return this._cacheable;
    }

    public List<ContentGenerator> generators() {
        return this._generators;
    }

    public List<Parameter> parameters(ContentGenerator generator) {
        List<Parameter> parameters = this._parameters.get(generator);
        if (parameters == null) {
            return Collections.emptyList();
        }
        return parameters;
    }

    public @Nullable String target(ContentGenerator generator) {
        return this._targets.get(generator);
    }

    public String name(ContentGenerator generator) {
        String name = this._names.get(generator);
        return name != null ? name : generator.getClass().getSimpleName();
    }

    public boolean affectStatus(ContentGenerator generator) {
        if (this._rule.appliesToAll()) {
            return true;
        }
        ServiceStatusRule.SelectType use = this._rule.use();
        switch (use) {
            case NAME: {
                return this._rule.appliesTo(this.name(generator));
            }
            case TARGET: {
                return this._rule.appliesTo(this.target(generator));
            }
        }
        return false;
    }

    public String toString() {
        return "service:" + this._group + "/" + this._id;
    }

    @Beta
    public void toXML(XMLWriter xml, HttpMethod method, List<String> urls) throws IOException {
        this.toXML(xml, method, urls, null);
    }

    @Beta
    public void toXML(XMLWriter xml, HttpMethod method, List<String> urls, @Nullable String cacheControl) throws IOException {
        xml.openElement("service", true);
        xml.attribute("id", this._id);
        xml.attribute("group", this._group);
        if (method != null) {
            xml.attribute("method", method.toString().toLowerCase());
        }
        if (this._flags.length() > 0) {
            xml.attribute("flags", this._flags);
        }
        xml.attribute("cacheable", Boolean.toString(this._cacheable));
        if (this._cacheable) {
            if (this._cache.length() > 0) {
                xml.attribute("cache-control", this._cache.length());
            } else if (cacheControl != null) {
                xml.attribute("cache-control", cacheControl);
            }
        }
        xml.openElement("response-code", true);
        xml.attribute("use", this._rule.use().toString().toLowerCase());
        xml.attribute("rule", this._rule.rule().toString().toLowerCase());
        xml.closeElement();
        if (urls != null) {
            for (String url : urls) {
                xml.openElement("url", true);
                xml.attribute("pattern", url);
                xml.closeElement();
            }
        }
        for (ContentGenerator generator : this._generators) {
            String target = this.target(generator);
            List<Parameter> parameters = this.parameters(generator);
            xml.openElement("generator", !parameters.isEmpty());
            xml.attribute("class", generator.getClass().getName());
            xml.attribute("name", this.name(generator));
            if (target != null) {
                xml.attribute("target", target);
            }
            xml.attribute("cacheable", Boolean.toString(generator instanceof Cacheable));
            xml.attribute("affect-status", Boolean.toString(this.affectStatus(generator)));
            for (Parameter p : parameters) {
                xml.openElement("parameter", false);
                xml.attribute("name", p.name());
                xml.attribute("value", p.value());
                xml.closeElement();
            }
            xml.closeElement();
        }
        xml.closeElement();
    }

    static boolean isCacheable(List<ContentGenerator> generators) {
        for (ContentGenerator g : generators) {
            if (g instanceof Cacheable) continue;
            return false;
        }
        return true;
    }

    private static <T> List<T> immutableList(List<@NonNull T> original) {
        if (original.isEmpty()) {
            return Collections.emptyList();
        }
        if (original.size() == 1) {
            return Collections.singletonList(original.get(0));
        }
        return Collections.unmodifiableList(new ArrayList<T>(original));
    }

    private static Map<ContentGenerator, List<Parameter>> immutableMap(Map<ContentGenerator, List<Parameter>> original) {
        if (original.isEmpty()) {
            return Collections.emptyMap();
        }
        if (original.size() == 1) {
            Map.Entry<ContentGenerator, List<Parameter>> entry = original.entrySet().iterator().next();
            return Collections.singletonMap(entry.getKey(), Service.immutableList(entry.getValue()));
        }
        HashMap<ContentGenerator, List<Parameter>> map = new HashMap<ContentGenerator, List<Parameter>>();
        for (Map.Entry<ContentGenerator, List<Parameter>> entry : original.entrySet()) {
            map.put(entry.getKey(), Service.immutableList(entry.getValue()));
        }
        return Collections.unmodifiableMap(map);
    }

    private static Map<ContentGenerator, String> immutable3(Map<ContentGenerator, String> original) {
        if (original.isEmpty()) {
            return Collections.emptyMap();
        }
        if (original.size() == 1) {
            Map.Entry<ContentGenerator, String> entry = original.entrySet().iterator().next();
            return Collections.singletonMap(entry.getKey(), entry.getValue());
        }
        HashMap<ContentGenerator, String> map = new HashMap<ContentGenerator, String>();
        for (Map.Entry<ContentGenerator, String> entry : original.entrySet()) {
            map.put(entry.getKey(), entry.getValue());
        }
        return Collections.unmodifiableMap(map);
    }

    static final class Builder {
        private @Nullable String id;
        private String group = "default";
        private String cache = "";
        private String flags = "";
        private @Nullable ServiceStatusRule rule;
        private final List<ContentGenerator> _generators = new ArrayList<ContentGenerator>();
        private final Map<ContentGenerator, List<Parameter>> _parameters = new HashMap<ContentGenerator, List<Parameter>>();
        private final Map<ContentGenerator, String> _names = new HashMap<ContentGenerator, String>();
        private final Map<ContentGenerator, String> _targets = new HashMap<ContentGenerator, String>();

        public @Nullable String id() {
            return this.id;
        }

        public String group() {
            return this.group;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder group(@Nullable String group) {
            this.group = group != null ? group : "default";
            return this;
        }

        public Builder cache(@Nullable String cache) {
            this.cache = cache != null ? cache : "";
            return this;
        }

        public Builder flags(@Nullable String flags) {
            this.flags = flags != null ? flags : "";
            return this;
        }

        public Builder rule(ServiceStatusRule rule) {
            this.rule = rule;
            return this;
        }

        public Builder parameter(@Nullable Parameter p) {
            if (this._generators.size() > 0 && p != null) {
                ContentGenerator generator = this._generators.get(this._generators.size() - 1);
                List parameters = this._parameters.computeIfAbsent(generator, k -> new ArrayList());
                parameters.add(p);
            }
            return this;
        }

        public Builder add(ContentGenerator g) {
            this._generators.add(g);
            return this;
        }

        public Builder target(@Nullable String target) {
            if (this._generators.size() > 0 && target != null) {
                ContentGenerator generator = this._generators.get(this._generators.size() - 1);
                this._targets.put(generator, target);
            }
            return this;
        }

        public Builder name(@Nullable String name) {
            if (this._generators.size() > 0 && name != null) {
                ContentGenerator generator = this._generators.get(this._generators.size() - 1);
                this._names.put(generator, name);
            }
            return this;
        }

        public Service build() {
            if (this.cache.length() > 0 && !Service.isCacheable(this._generators)) {
                Logger logger = LoggerFactory.getLogger(Builder.class);
                logger.warn("Building non-cacheable service {} - cache control ignored.", (Object)this.id);
            }
            return new Service(this);
        }

        public void reset() {
            this.id = null;
            this.cache = "";
            this.flags = "";
            this._generators.clear();
            this._parameters.clear();
            this._names.clear();
            this._targets.clear();
        }
    }
}

