/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.berlioz.BerliozOption;
import org.pageseeder.berlioz.Beta;
import org.pageseeder.berlioz.ConfigListener;
import org.pageseeder.berlioz.InitEnvironment;
import org.pageseeder.berlioz.xml.XMLConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GlobalSettings {
    private static final Logger LOGGER = LoggerFactory.getLogger(GlobalSettings.class);
    @Deprecated
    public static final String CONFIG_DIRECTORY = "config";
    @Deprecated
    public static final String LIBRARY_DIRECTORY = "library";
    public static final String DEFAULT_MODE = "default";
    private static volatile InitEnvironment env = null;
    private static volatile @Nullable Map<String, String> settings;
    private static volatile @Nullable Map<String, Properties> nodes;
    private static final List<ConfigListener> LISTENERS;

    private GlobalSettings() {
    }

    public static @Nullable File getWebInf() {
        return env != null ? env.webInf() : null;
    }

    public static @Nullable File getAppData() {
        return env != null ? env.appData() : null;
    }

    public static File getConfig() {
        if (env != null) {
            return env.webInf().toPath().resolve(env.configFolder()).toFile();
        }
        return null;
    }

    public static int countProperties() {
        return GlobalSettings.ensureSettings().size();
    }

    public static String getVersion() {
        Package p = Package.getPackage("org.pageseeder.berlioz");
        String v = p != null ? p.getImplementationVersion() : "unknown";
        return v != null ? v : "unknown";
    }

    public static String getMode() {
        return env != null ? env.mode() : DEFAULT_MODE;
    }

    public static @Nullable File getPropertiesFile() {
        if (env == null) {
            return null;
        }
        File f = GlobalSettings.getModeConfigFile();
        if (f == null) {
            f = GlobalSettings.getDefaultConfigFile();
        }
        return f;
    }

    public static @Nullable File getModeConfigFile() {
        if (env == null) {
            return null;
        }
        File appDataConfigDirectory = env.appData().toPath().resolve(env.configFolder()).toFile();
        File f = GlobalSettings.getModeConfigFile(appDataConfigDirectory);
        if (f == null || !f.exists()) {
            f = GlobalSettings.getModeConfigFile(GlobalSettings.getConfig());
        }
        return f;
    }

    public static @Nullable File getDefaultConfigFile() {
        if (env == null) {
            return null;
        }
        return GlobalSettings.getDefaultConfigFile(GlobalSettings.getConfig());
    }

    public static @Nullable String get(String name) throws IllegalStateException {
        return GlobalSettings.ensureSettings().get(name);
    }

    public static String get(BerliozOption option) throws IllegalStateException {
        return GlobalSettings.get(option.property(), option.defaultTo().toString());
    }

    public static boolean has(BerliozOption option) {
        Objects.requireNonNull(option, "No Berlioz option specified");
        @Nullable String value = GlobalSettings.ensureSettings().get(option.property());
        Object def = option.defaultTo();
        if (option.isBoolean()) {
            return value != null ? Boolean.parseBoolean(value) : (Boolean)def;
        }
        throw new IllegalArgumentException("Trying to get non-boolean option '" + option.property() + "' as boolean.");
    }

    public static String get(String name, String def) throws IllegalStateException {
        @Nullable String value = GlobalSettings.ensureSettings().get(name);
        return value == null ? def : value;
    }

    public static int get(String name, int def) throws IllegalStateException {
        try {
            @Nullable String value = GlobalSettings.ensureSettings().get(name);
            return value == null ? def : Integer.parseInt(value);
        }
        catch (NumberFormatException ex) {
            return def;
        }
    }

    public static boolean get(String name, boolean def) throws IllegalStateException {
        @Nullable String value = GlobalSettings.ensureSettings().get(name);
        if (value == null) {
            return def;
        }
        return def ? !"false".equals(value) : "true".equals(value);
    }

    public static File get(String name, File def) throws IllegalStateException {
        File file = GlobalSettings.getFileProperty(name);
        return file != null ? file : def;
    }

    public static @Nullable File getDirProperty(String name) throws IllegalStateException {
        File file = GlobalSettings.getFileProperty(name);
        if (file != null && file.isDirectory()) {
            return file;
        }
        return null;
    }

    public static @Nullable File getFileProperty(String name) throws IllegalStateException {
        @Nullable String filepath = GlobalSettings.ensureSettings().get(name);
        if (filepath != null && env != null) {
            File file = new File(env.appData(), filepath);
            try {
                if (file.exists()) {
                    return file.getCanonicalFile();
                }
            }
            catch (IOException ex) {
                LOGGER.warn("Unable to generate canonical file: {}", (Object)ex.getMessage());
            }
            if (env.appData() != env.webInf()) {
                file = new File(env.webInf(), filepath);
                try {
                    if (file.exists()) {
                        return file.getCanonicalFile();
                    }
                }
                catch (IOException ex) {
                    LOGGER.warn("Unable to generate canonical file: {}", (Object)ex.getMessage());
                }
            }
        }
        return null;
    }

    public static @Nullable Properties getNode(String name) {
        Map<String, Properties> all = nodes;
        if (all == null) {
            return null;
        }
        if (all.containsKey(name)) {
            return all.get(name);
        }
        Properties node = new Properties();
        String prefix = name + '.';
        for (Map.Entry<String, String> e : GlobalSettings.ensureSettings().entrySet()) {
            String key = e.getKey();
            if (!key.startsWith(prefix) || key.substring(prefix.length()).indexOf(46) >= 0) continue;
            node.setProperty(key.substring(prefix.length()), e.getValue());
        }
        all.put(name, node);
        return node;
    }

    public static Enumeration<String> propertyNames() throws IllegalStateException {
        return Collections.enumeration(GlobalSettings.ensureSettings().keySet());
    }

    public static Map<String, String> getAll() throws IllegalStateException {
        return Collections.unmodifiableMap(GlobalSettings.ensureSettings());
    }

    public static void setup(InitEnvironment environment) {
        env = environment;
    }

    public static void setup(File webInf) {
        env = InitEnvironment.create(webInf);
    }

    @Deprecated
    public static void setWebInf(File dir) {
        env = env != null ? env.webInf(dir) : InitEnvironment.create(dir);
    }

    @Deprecated
    public static void setAppData(File dir) {
        if (env != null) {
            env = env.appData(dir);
        }
    }

    @Deprecated
    public static void setMode(String name) {
        if (env != null) {
            env = env.mode(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean load() throws IllegalStateException {
        boolean loaded = false;
        HashMap<String, String> properties = new HashMap<String, String>();
        try {
            File modeConfig;
            if (env == null) {
                boolean bl = false;
                return bl;
            }
            File defaultConfig = GlobalSettings.getDefaultConfigFile();
            if (defaultConfig != null) {
                GlobalSettings.loadInto(defaultConfig, properties);
            }
            if ((modeConfig = GlobalSettings.getModeConfigFile()) != null) {
                GlobalSettings.loadInto(modeConfig, properties);
            }
            loaded = defaultConfig != null || modeConfig != null;
        }
        catch (IOException ex) {
            System.err.println("[BERLIOZ_CONFIG] (!) An error occurred whilst trying to read the properties file.");
            LOGGER.warn("Unable to load the configuration file: {}", (Object)ex.getMessage());
            properties.clear();
        }
        catch (Exception ex) {
            System.err.println("[BERLIOZ_CONFIG] (!) An error occurred whilst trying to read the properties file.");
            LOGGER.warn("Unable to load the configuration file", (Throwable)ex);
            properties.clear();
        }
        finally {
            settings = properties;
            nodes = new Hashtable<String, Properties>();
        }
        if (loaded) {
            for (ConfigListener listener : LISTENERS) {
                try {
                    listener.load();
                }
                catch (Exception ex) {
                    LOGGER.warn("Listener threw an exception", (Throwable)ex);
                }
            }
        }
        return loaded;
    }

    @Beta
    public static void registerListener(ConfigListener listener) {
        LISTENERS.add(listener);
    }

    @Beta
    public static void removeAllListeners() {
        LISTENERS.clear();
    }

    @Deprecated
    public static @Nullable File getRepository() {
        return env.appData();
    }

    @Deprecated
    public static void setRepository(File dir) {
        if (dir == null) {
            return;
        }
        env = InitEnvironment.create(dir);
    }

    @Deprecated
    public static File getLibrary() {
        return new File(env.appData(), LIBRARY_DIRECTORY);
    }

    private static void loadInto(File file, Map<String, String> properties) throws IOException {
        Format format = file.getName().endsWith(".xml") ? Format.XML_CONFIG : Format.PROPERTIES;
        LOGGER.debug("Loading Berlioz config {} as {}", (Object)file.getName(), (Object)format);
        switch (format) {
            case XML_CONFIG: {
                GlobalSettings.loadXMLConfig(file, properties);
                break;
            }
            case PROPERTIES: {
                GlobalSettings.loadProperties(file, properties);
            }
        }
    }

    private static void loadProperties(File file, Map<String, String> map) throws IOException {
        Properties p = new Properties();
        try (FileInputStream in = new FileInputStream(file);){
            p.load(in);
            for (Map.Entry<Object, Object> e : p.entrySet()) {
                map.put(e.getKey().toString(), e.getValue().toString());
            }
        }
    }

    private static void loadXMLConfig(File file, Map<String, String> map) throws IOException {
        XMLConfig config = new XMLConfig(map);
        Path path = GlobalSettings.checkPath(file);
        try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
            config.load(in);
        }
    }

    private static @Nullable File getModeConfigFile(File dir) {
        if (dir == null || !dir.isDirectory()) {
            return null;
        }
        File xml = new File(dir, "config-" + GlobalSettings.getMode() + ".xml");
        if (xml.canRead()) {
            return xml;
        }
        File prp = new File(dir, "config-" + GlobalSettings.getMode() + ".properties");
        if (prp.canRead()) {
            return prp;
        }
        return null;
    }

    private static @Nullable File getDefaultConfigFile(File dir) {
        if (dir == null || !dir.isDirectory()) {
            return null;
        }
        File xml = new File(dir, "config.xml");
        if (xml.canRead()) {
            return xml;
        }
        File prp = new File(dir, "config.properties");
        if (prp.canRead()) {
            return prp;
        }
        return null;
    }

    private static Map<String, String> ensureSettings() throws IllegalStateException {
        Map<String, String> s;
        if (settings == null) {
            GlobalSettings.load();
        }
        return (s = settings) != null ? s : Collections.emptyMap();
    }

    private static Path checkPath(File file) throws IOException {
        String path = file.getCanonicalPath();
        if (path.startsWith(env.appData().getCanonicalPath()) || path.startsWith(env.webInf().getCanonicalPath())) {
            return file.toPath();
        }
        throw new IOException("Config file must be located within webinf or appdata folder");
    }

    static {
        LISTENERS = new ArrayList<ConfigListener>();
    }

    private static enum Format {
        XML_CONFIG,
        PROPERTIES;

    }
}

