/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.xml;

import java.io.PrintWriter;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.pageseeder.diffx.token.XMLToken;
import org.pageseeder.diffx.xml.NamespaceSet;

public final class Sequence
extends AbstractList<XMLToken>
implements List<XMLToken> {
    private final NamespaceSet namespaces = new NamespaceSet();
    private final List<XMLToken> tokens;

    public Sequence() {
        this.tokens = new ArrayList<XMLToken>();
    }

    public Sequence(int size) {
        this.tokens = new ArrayList<XMLToken>(size);
    }

    public Sequence(List<XMLToken> tokens, NamespaceSet namespaces) {
        this.tokens = tokens;
        this.namespaces.add(namespaces);
    }

    public Sequence(NamespaceSet namespaces) {
        this.tokens = new ArrayList<XMLToken>();
        this.namespaces.add(namespaces);
    }

    public Sequence(List<XMLToken> tokens) {
        this.tokens = tokens;
    }

    public void addSequence(@NotNull Sequence sequence) {
        this.tokens.addAll(sequence.tokens);
        this.namespaces.add(sequence.namespaces);
    }

    @Override
    public XMLToken get(int index) {
        return this.tokens.get(index);
    }

    @Override
    public void add(int index, XMLToken token) {
        this.tokens.add(index, token);
    }

    @Override
    public boolean add(XMLToken token) {
        return this.tokens.add(token);
    }

    public void addToken(XMLToken token) {
        this.tokens.add(token);
    }

    public void addToken(int i, XMLToken token) {
        this.tokens.add(i, token);
    }

    public void addTokens(List<? extends XMLToken> tokens) {
        this.tokens.addAll(tokens);
    }

    public XMLToken getToken(int i) {
        return this.tokens.get(i);
    }

    public XMLToken setToken(int index, XMLToken token) {
        return this.tokens.set(index, token);
    }

    public XMLToken removeToken(int index) {
        return this.tokens.remove(index);
    }

    @Override
    public int size() {
        return this.tokens.size();
    }

    public List<XMLToken> tokens() {
        return this.tokens;
    }

    @Override
    public int hashCode() {
        return this.tokens.size();
    }

    public boolean equals(Sequence seq) {
        if (seq == null) {
            return false;
        }
        return Sequence.equals(this.tokens, seq.tokens);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof Sequence)) {
            return false;
        }
        return this.equals((Sequence)o);
    }

    @Override
    public String toString() {
        return "XMLSequence{namespaces=" + String.valueOf(this.namespaces) + ", tokens=" + String.valueOf(this.tokens) + "}";
    }

    public void export(PrintWriter w) {
        for (XMLToken token : this.tokens) {
            w.println(token.toString());
        }
        w.flush();
    }

    public void addNamespace(String uri, String prefix, boolean replace) throws NullPointerException {
        if (replace) {
            this.namespaces.replace(uri, prefix);
        } else {
            this.namespaces.add(uri, prefix);
        }
    }

    public void addNamespace(String uri, String prefix) throws NullPointerException {
        this.namespaces.add(uri, prefix);
    }

    public NamespaceSet getNamespaces() {
        return this.namespaces;
    }

    @Override
    @NotNull
    public Iterator<XMLToken> iterator() {
        return this.tokens.iterator();
    }

    private static boolean equals(List<XMLToken> first, List<XMLToken> second) {
        if (first.size() != second.size()) {
            return false;
        }
        for (int i = 0; i < first.size(); ++i) {
            XMLToken x2;
            XMLToken x1 = first.get(i);
            if (x1.equals(x2 = second.get(i))) continue;
            return false;
        }
        return true;
    }
}

