/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.xml;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.pageseeder.diffx.xml.Namespace;

public final class NamespaceSet
extends AbstractCollection<Namespace>
implements Collection<Namespace> {
    private final Map<String, Namespace> namespacesByUri = new HashMap<String, Namespace>();
    private final Map<String, Namespace> namespacesByPrefix = new HashMap<String, Namespace>();

    public NamespaceSet() {
    }

    public NamespaceSet(Namespace namespace) {
        this.namespacesByUri.put(namespace.getUri(), namespace);
        this.namespacesByPrefix.put(namespace.getPrefix(), namespace);
    }

    public static NamespaceSet noNamespace() {
        return new NamespaceSet(Namespace.NO_NAMESPACE);
    }

    public boolean add(@NotNull String uri, @NotNull String prefix) throws NullPointerException {
        if (!this.namespacesByUri.containsKey(uri)) {
            int count = 0;
            String actualPrefix = prefix;
            while (this.namespacesByPrefix.containsKey(actualPrefix)) {
                actualPrefix = NamespaceSet.autoprefix(uri, prefix, count++);
            }
            Namespace namespace = new Namespace(uri, actualPrefix);
            this.namespacesByUri.put(uri, namespace);
            this.namespacesByPrefix.put(actualPrefix, namespace);
            return true;
        }
        return false;
    }

    private static String autoprefix(String uri, String prefix, int count) {
        if (prefix.isEmpty()) {
            Namespace common = Namespace.getCommon(uri);
            if (common != null) {
                return count == 0 ? common.getPrefix() : common.getPrefix() + count;
            }
            return "ns" + count;
        }
        return prefix + count;
    }

    @Override
    public boolean add(Namespace namespace) {
        return this.add(namespace.getUri(), namespace.getPrefix());
    }

    public Namespace replace(String uri, String prefix) throws NullPointerException {
        return this.replace(new Namespace(uri, prefix));
    }

    public Namespace replace(Namespace namespace) throws NullPointerException {
        Namespace matching;
        if (this.contains(namespace)) {
            return namespace;
        }
        Namespace previous = this.namespacesByUri.put(namespace.getUri(), namespace);
        if (previous != null) {
            this.namespacesByPrefix.remove(previous.getPrefix());
        }
        if ((matching = this.namespacesByPrefix.put(namespace.getPrefix(), namespace)) != null) {
            this.namespacesByUri.remove(matching.getUri());
        }
        if (matching != null && !matching.getUri().equals("")) {
            this.add(matching);
        }
        return previous;
    }

    @Override
    public void clear() {
        this.namespacesByUri.clear();
        this.namespacesByPrefix.clear();
    }

    @Override
    public int size() {
        return this.namespacesByUri.size();
    }

    public void add(NamespaceSet other) {
        this.addAll(other);
    }

    @Override
    @NotNull
    public Iterator<Namespace> iterator() {
        return Collections.unmodifiableCollection(this.namespacesByUri.values()).iterator();
    }

    public Map<String, String> toMap() {
        HashMap<String, String> map = new HashMap<String, String>(this.namespacesByUri.values().size());
        this.namespacesByUri.values().forEach(namespace -> map.put(namespace.getUri(), namespace.getPrefix()));
        return map;
    }

    public String getPrefix(String uri) {
        Namespace namespace = this.namespacesByUri.get(uri);
        return namespace != null ? namespace.getPrefix() : null;
    }

    public String getUri(String prefix) {
        Namespace namespace = this.namespacesByPrefix.get(prefix);
        return namespace != null ? namespace.getUri() : null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NamespaceSet mapping = (NamespaceSet)o;
        return this.namespacesByUri.equals(mapping.namespacesByUri);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.namespacesByUri.values());
    }

    @Override
    public String toString() {
        return "(" + String.valueOf(this.namespacesByUri.values()) + ")";
    }

    public static NamespaceSet merge(NamespaceSet a, NamespaceSet b) {
        NamespaceSet namespaces = new NamespaceSet();
        namespaces.add(a);
        namespaces.add(b);
        return namespaces;
    }
}

