/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.token.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jetbrains.annotations.NotNull;
import org.pageseeder.diffx.token.ElementToken;
import org.pageseeder.diffx.token.EndElementToken;
import org.pageseeder.diffx.token.StartElementToken;
import org.pageseeder.diffx.token.XMLToken;
import org.pageseeder.diffx.token.impl.TokenBase;
import org.pageseeder.xmlwriter.XMLWriter;

public class XMLElement
extends TokenBase
implements ElementToken {
    @NotNull
    private final StartElementToken start;
    @NotNull
    private final EndElementToken end;
    @NotNull
    private final List<XMLToken> content;
    private final int hashCode;

    public XMLElement(@NotNull StartElementToken start, @NotNull EndElementToken end, @NotNull List<XMLToken> content) {
        this.start = Objects.requireNonNull(start, "The start element must not be null.");
        this.end = Objects.requireNonNull(end, "The end element must not be null.");
        this.content = Objects.requireNonNull(content, "The content must not be null.");
        this.hashCode = XMLElement.toHashCode(start, this.content);
    }

    @Override
    @NotNull
    public StartElementToken getStart() {
        return this.start;
    }

    @Override
    @NotNull
    public EndElementToken getEnd() {
        return this.end;
    }

    @Override
    @NotNull
    public String getName() {
        return this.start.getName();
    }

    @Override
    @NotNull
    public String getNamespaceURI() {
        return this.start.getNamespaceURI();
    }

    @Override
    public String getValue() {
        return null;
    }

    @Override
    @Deprecated(since="1.1.2", forRemoval=true)
    public List<XMLToken> getEvents() {
        return this.tokens();
    }

    @Override
    @NotNull
    public List<XMLToken> tokens() {
        ArrayList<XMLToken> tokens = new ArrayList<XMLToken>(1 + this.content.size() + 1);
        tokens.add(this.start);
        tokens.addAll(this.content);
        tokens.add(this.end);
        return tokens;
    }

    @Override
    @Deprecated(since="1.2.0", forRemoval=true)
    public List<XMLToken> getChildren() {
        return this.content;
    }

    @Override
    @NotNull
    public List<XMLToken> getContent() {
        return this.content;
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean equals(XMLToken token) {
        if (token.getClass() != this.getClass()) {
            return false;
        }
        XMLElement element = (XMLElement)token;
        if (element.hashCode != this.hashCode) {
            return false;
        }
        if (!element.start.equals(this.start)) {
            return false;
        }
        if (element.content.size() != this.content.size()) {
            return false;
        }
        return element.content.equals(this.content);
    }

    public String toString() {
        return "element: " + this.getName();
    }

    public void toXML(XMLWriter xml) throws IOException {
        this.start.toXML(xml);
        for (XMLToken token : this.content) {
            token.toXML(xml);
        }
        this.end.toXML(xml);
    }

    @Override
    public void toXML(@NotNull XMLStreamWriter xml) throws XMLStreamException {
        this.start.toXML(xml);
        for (XMLToken token : this.content) {
            token.toXML(xml);
        }
        this.end.toXML(xml);
    }

    private static int toHashCode(StartElementToken start, List<XMLToken> content) {
        int result = 1;
        result = 31 * result + start.hashCode();
        for (XMLToken token : content) {
            result = 31 * result + (token == null ? 0 : token.hashCode());
        }
        return result;
    }
}

