/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.token;

import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jetbrains.annotations.NotNull;
import org.pageseeder.diffx.token.XMLToken;
import org.pageseeder.diffx.token.XMLTokenType;
import org.pageseeder.xmlwriter.XMLWriter;

public interface TextToken
extends XMLToken {
    public String getCharacters();

    @Override
    @NotNull
    default public XMLTokenType getType() {
        return XMLTokenType.TEXT;
    }

    @Override
    @NotNull
    default public String getName() {
        return "";
    }

    @Override
    @NotNull
    default public String getValue() {
        return this.getCharacters();
    }

    @Override
    default public boolean isWhitespace() {
        String value = this.getValue();
        for (int i = 0; i < value.length(); ++i) {
            if (Character.isWhitespace(value.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    default public boolean equals(XMLToken token) {
        if (token == this) {
            return true;
        }
        if (!(token instanceof TextToken)) {
            return false;
        }
        TextToken other = (TextToken)token;
        return this.getValue().equals(other.getValue());
    }

    @Override
    @NotNull
    default public String getNamespaceURI() {
        return "";
    }

    default public void toXML(XMLWriter xml) throws IOException {
        xml.writeText(this.getCharacters());
    }

    @Override
    default public void toXML(@NotNull XMLStreamWriter xml) throws XMLStreamException {
        xml.writeCharacters(this.getCharacters());
    }
}

